/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.controllers.ContextController;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.controllers.DocumentationController;
import com.android.tools.idea.editors.gfxtrace.controllers.FrameBufferController;
import com.android.tools.idea.editors.gfxtrace.controllers.MemoryController;
import com.android.tools.idea.editors.gfxtrace.controllers.ScrubberController;
import com.android.tools.idea.editors.gfxtrace.controllers.StateController;
import com.android.tools.idea.editors.gfxtrace.controllers.TexturesController;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MainController
extends Controller {
    private JBPanel myPanel = new JBPanel((LayoutManager)new BorderLayout());

    public static JComponent createUI(GfxTraceEditor editor) {
        return new MainController((GfxTraceEditor)editor).myPanel;
    }

    private MainController(GfxTraceEditor editor) {
        super(editor);
        ThreeComponentsSplitter threePanes = new ThreeComponentsSplitter(true);
        this.myPanel.add((Component)threePanes, (Object)"Center");
        threePanes.setDividerWidth(5);
        this.myPanel.add((Component)ContextController.createUI(editor), (Object)"North");
        threePanes.setFirstComponent(ScrubberController.createUI(editor));
        threePanes.setFirstSize(150);
        JBSplitter middleSplitter = new JBSplitter(false);
        middleSplitter.setMinimumSize((Dimension)JBUI.size((int)100, (int)10));
        middleSplitter.setFirstComponent(AtomController.createUI(editor));
        middleSplitter.setSecondComponent(FrameBufferController.createUI(editor));
        middleSplitter.setProportion(0.3f);
        threePanes.setInnerComponent((JComponent)middleSplitter);
        JBRunnerTabs miscTabs = new JBRunnerTabs(editor.getProject(), ActionManager.getInstance(), IdeFocusManager.findInstance(), (Disposable)this);
        miscTabs.setPaintBorder(0, 0, 0, 0).setTabSidePaintBorder(1).setPaintFocus(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()).setAlwaysPaintSelectedTab(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
        miscTabs.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)0, (int)0));
        miscTabs.addTab(new TabInfo(TexturesController.createUI(editor)).setText("Textures"));
        miscTabs.addTab(new TabInfo(MemoryController.createUI(editor)).setText("Memory"));
        miscTabs.addTab(new TabInfo(DocumentationController.createUI(editor)).setText("Docs"));
        JPanel miscPanel = new JPanel(new BorderLayout());
        miscPanel.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        miscPanel.add((Component)miscTabs, "Center");
        JBSplitter bottomSplitter = new JBSplitter(false);
        bottomSplitter.setMinimumSize((Dimension)JBUI.size((int)100, (int)10));
        bottomSplitter.setFirstComponent(StateController.createUI(editor));
        bottomSplitter.setSecondComponent((JComponent)miscPanel);
        threePanes.setLastComponent((JComponent)bottomSplitter);
        threePanes.setLastSize(300);
        threePanes.setHonorComponentsMinimumSize(true);
        Disposer.register((Disposable)this, (Disposable)threePanes);
    }

    @Override
    public void notifyPath(Path path) {
    }

    @Override
    public void clear() {
        this.myPanel.removeAll();
    }
}

