/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.TreeController;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.StatePath;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Map;
import com.android.tools.rpclib.schema.Type;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public class StateController
extends TreeController {
    private static final Logger LOG = Logger.getInstance(StateController.class);
    private final PathStore<StatePath> myStatePath = new PathStore();

    public static JComponent createUI(GfxTraceEditor editor) {
        return new StateController((GfxTraceEditor)editor).myPanel;
    }

    private StateController(GfxTraceEditor editor) {
        super(editor, "Select an atom");
    }

    private static DefaultMutableTreeNode createNode(Object key, Type type, Object value) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode();
        StateController.fillNode(child, key, value);
        if (child.getChildCount() != 0) {
            child.setUserObject(new Node(key, null));
        } else if (type != null && value != null) {
            child.setUserObject(new Node(key, new Typed(type, value)));
        } else {
            child.setUserObject(new Node(key, value));
        }
        return child;
    }

    private static void fillNode(DefaultMutableTreeNode parent, Object key, Object value) {
        block5: {
            Field field;
            block4: {
                if (!(value instanceof Dynamic)) break block4;
                Dynamic dynamic = (Dynamic)value;
                for (int index = 0; index < dynamic.getFieldCount(); ++index) {
                    Field field2 = dynamic.getFieldInfo(index);
                    if (field2.getDeclared().length() == 0) {
                        StateController.fillNode(parent, field2, dynamic.getFieldValue(index));
                        continue;
                    }
                    parent.add(StateController.createNode(field2, field2.getType(), dynamic.getFieldValue(index)));
                }
                break block5;
            }
            if (!(key instanceof Field) || !((field = (Field)key).getType() instanceof Map)) break block5;
            assert (value instanceof java.util.Map);
            Map map = (Map)field.getType();
            for (Map.Entry entry : ((java.util.Map)value).entrySet()) {
                parent.add(StateController.createNode(new Typed(map.getKeyType(), entry.getKey()), map.getValueType(), entry.getValue()));
            }
        }
    }

    @Override
    public void notifyPath(Path path) {
        boolean updateState = false;
        if (path instanceof AtomPath) {
            updateState |= this.myStatePath.update(((AtomPath)path).stateAfter());
        }
        if (updateState && this.myStatePath.getPath() != null) {
            Futures.addCallback(this.myEditor.getClient().get(this.myStatePath.getPath()), (FutureCallback)new LoadingCallback<Object>(LOG, this.myLoadingPanel){

                public void onSuccess(Object state) {
                    final DefaultMutableTreeNode stateNode = StateController.createNode("state", null, state);
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            StateController.this.setRoot(stateNode);
                        }
                    });
                }
            });
        }
    }

    public static class Node {
        public final Object key;
        public final Object value;

        public Node(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class Typed {
        public final Type type;
        public final Object value;

        public Typed(Type type, Object value) {
            this.type = type;
            this.value = value;
        }
    }
}

