/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.CellController;
import com.android.tools.idea.editors.gfxtrace.service.ResourceInfo;
import com.android.tools.idea.editors.gfxtrace.service.Resources;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcesPath;
import com.android.tools.idea.editors.gfxtrace.service.path.ThumbnailPath;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class TexturesController
extends CellController<Data> {
    private static final Logger LOG = Logger.getInstance(TexturesController.class);
    private final PathStore<ResourcesPath> myResourcesPath = new PathStore();
    private final PathStore<AtomPath> myAtomPath = new PathStore();
    private Resources myResources;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new TexturesController((GfxTraceEditor)editor).myPanel;
    }

    private TexturesController(GfxTraceEditor editor) {
        super(editor);
        this.myList.setLayoutOrientation(0);
    }

    @Override
    void selected(Data cell) {
    }

    @Override
    public boolean loadCell(Data cell) {
        ServiceClient client = this.myEditor.getClient();
        ThumbnailPath path = cell.path.thumbnail(this.myRenderer.getCellDimensions());
        this.loadCellImage(cell, client, path);
        return true;
    }

    void update() {
        if (this.myAtomPath.getPath() != null && this.myResources != null) {
            final AtomPath atomPath = this.myAtomPath.getPath();
            final Resources resources = this.myResources;
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<Data> cells = new ArrayList<Data>();
                    for (ResourceInfo info : resources.getTextures()) {
                        cells.add(new Data(info, atomPath.resourceAfter(info.getID()), TexturesController.this.myRenderer.getDefaultIcon()));
                    }
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            TexturesController.this.populateUi(cells);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void notifyPath(Path path) {
        boolean updateIcons = false;
        if (path instanceof CapturePath && this.myResourcesPath.update(((CapturePath)path).resources())) {
            Futures.addCallback(this.myEditor.getClient().get(this.myResourcesPath.getPath()), (FutureCallback)new LoadingCallback<Resources>(LOG){

                public void onSuccess(final Resources resources) {
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            TexturesController.this.myResources = resources;
                            TexturesController.this.update();
                        }
                    });
                }
            });
        }
        if (path instanceof AtomPath && this.myAtomPath.update((AtomPath)path)) {
            this.update();
        }
    }

    public static class Data
    extends CellController.Data {
        public final ResourceInfo info;
        public final ResourcePath path;

        public Data(ResourceInfo info, ResourcePath path, ImageIcon icon) {
            super(info.getName(), icon);
            this.info = info;
            this.path = path;
        }
    }
}

