/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.controllers.CellController;
import com.android.tools.idea.editors.gfxtrace.renderers.CellLabel;
import com.android.tools.idea.editors.gfxtrace.renderers.styles.RoundedLineBorder;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class CellRenderer
implements ListCellRenderer {
    private static final int BORDER_SIZE = JBUI.scale((int)5);
    private static final int MIN_WIDTH = JBUI.scale((int)64);
    private static final int MIN_HEIGHT = JBUI.scale((int)64);
    public static final int MAX_WIDTH = JBUI.scale((int)192);
    public static final int MAX_HEIGHT = JBUI.scale((int)192);
    private static final int TICK_MILLISECONDS = 66;
    private static final Border DEFAULT_BORDER = JBUI.Borders.empty((int)BORDER_SIZE, (int)BORDER_SIZE);
    private static final Border SELECTED_BORDER = new RoundedLineBorder(UIUtil.getFocusedBoundsColor(), JBUI.scale((int)5), false);
    private static final Dimension DEFAULT_IMAGE_SIZE = new Dimension(MAX_WIDTH, MAX_HEIGHT);
    private static final ScheduledExecutorService ourTickerScheduler = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"CellAnimation");
    private final CellLabel myCellLabel;
    private final CellController myCellLoader;
    private ImageIcon myBlankIcon;
    final Dimension myLargestKnownIconDimension = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private Runnable myTicker;

    public CellRenderer(CellController loader) {
        this.myCellLabel = new CellLabel();
        this.myCellLoader = loader;
        this.myBlankIcon = new ImageIcon(CellRenderer.createBlankImage(DEFAULT_IMAGE_SIZE));
    }

    private static Image createBlankImage(Dimension dimension) {
        BufferedImage blankImage = new BufferedImage(dimension.width, dimension.height, 12);
        Graphics2D g = blankImage.createGraphics();
        g.setPaint(UIUtil.getListForeground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.dispose();
        return blankImage;
    }

    public Component getListCellRendererComponent(final JList jList, Object data, int index, boolean isSelected, boolean cellHasFocus) {
        assert (data instanceof CellController.Data);
        final CellController.Data cell = (CellController.Data)data;
        this.myCellLabel.setUserData(cell);
        if (!cell.isLoaded() && !cell.isLoading && this.myCellLoader.startLoad(cell)) {
            cell.loadstartTime = System.currentTimeMillis();
            cell.isLoading = true;
            if (this.myTicker == null) {
                this.myTicker = new Runnable(){

                    @Override
                    public void run() {
                        EdtExecutor.INSTANCE.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (cell.isLoading) {
                                    jList.repaint();
                                    ourTickerScheduler.schedule(CellRenderer.this.myTicker, 66L, TimeUnit.MILLISECONDS);
                                } else {
                                    CellRenderer.this.myTicker = null;
                                }
                            }
                        });
                    }
                };
                this.myTicker.run();
            }
        }
        cell.isSelected = isSelected;
        this.myCellLabel.setBorder(isSelected ? SELECTED_BORDER : DEFAULT_BORDER);
        return this.myCellLabel;
    }

    public Dimension getCellDimensions() {
        return new Dimension(this.myLargestKnownIconDimension.width + 2 * BORDER_SIZE, this.myLargestKnownIconDimension.height + 2 * BORDER_SIZE);
    }

    public ImageIcon getDefaultIcon() {
        return this.myBlankIcon;
    }

    public boolean updateKnownSize(Dimension dimension) {
        boolean updated = false;
        if (this.myLargestKnownIconDimension.width < dimension.width) {
            updated = true;
            this.myLargestKnownIconDimension.width = dimension.width;
        }
        if (this.myLargestKnownIconDimension.height < dimension.height) {
            updated = true;
            this.myLargestKnownIconDimension.height = dimension.height;
        }
        if (updated) {
            this.myBlankIcon.setImage(CellRenderer.createBlankImage(this.myLargestKnownIconDimension));
            return true;
        }
        return false;
    }
}

