/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service;

import com.android.tools.idea.editors.gfxtrace.service.Schema;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientWrapper;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;

public class ServiceClientCache
extends ServiceClientWrapper {
    private ListenableFuture<Schema> mySchema;
    private final Object mySchemaLock = new Object();
    private final LoadingCache<Path, ListenableFuture<Object>> myPathCache = CacheBuilder.newBuilder().maximumSize(1000L).softValues().build((CacheLoader)new CacheLoader<Path, ListenableFuture<Object>>(){

        public ListenableFuture<Object> load(Path p) {
            return ServiceClientCache.this.myClient.get(p);
        }
    });
    private static final int MAXIMUM_CACHE_COUNT = 1000;

    public ServiceClientCache(ServiceClient client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Schema> getSchema() {
        Object object = this.mySchemaLock;
        synchronized (object) {
            if (this.mySchema == null) {
                this.mySchema = this.myClient.getSchema();
            }
        }
        return this.mySchema;
    }

    @Override
    public ListenableFuture<Object> get(Path p) {
        return (ListenableFuture)this.myPathCache.getUnchecked((Object)p);
    }
}

