/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.atom;

import com.android.tools.idea.editors.gfxtrace.service.atom.AtomList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Range;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

public final class AtomGroup
implements BinaryObject {
    private String myName;
    private Range myRange;
    private AtomGroup[] mySubGroups;
    private static final byte[] IDBytes = new byte[]{29, -128, -52, -6, -27, -70, 14, -120, 63, 17, 59, -43, 7, 22, 86, 19, -11, 67, 66, -21};
    public static final BinaryID ID = new BinaryID(IDBytes);

    public boolean isValid() {
        return this.myRange.isValid();
    }

    public void addChildren(DefaultMutableTreeNode parent, AtomList atoms) {
        long next = this.myRange.getStart();
        for (AtomGroup subGroup : this.mySubGroups) {
            atoms.addAtoms(parent, next, subGroup.getRange().getStart());
            DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(subGroup, true);
            subGroup.addChildren(subNode, atoms);
            parent.add(subNode);
            next = subGroup.getRange().getEnd();
        }
        atoms.addAtoms(parent, next, this.myRange.getEnd());
    }

    public String getName() {
        return this.myName;
    }

    public AtomGroup setName(String v) {
        this.myName = v;
        return this;
    }

    public Range getRange() {
        return this.myRange;
    }

    public AtomGroup setRange(Range v) {
        this.myRange = v;
        return this;
    }

    public AtomGroup[] getSubGroups() {
        return this.mySubGroups;
    }

    public AtomGroup setSubGroups(AtomGroup[] v) {
        this.mySubGroups = v;
        return this;
    }

    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static /* synthetic */ AtomGroup[] access$202(AtomGroup x0, AtomGroup[] x1) {
        x0.mySubGroups = x1;
        return x1;
    }

    static {
        Namespace.register((BinaryID)ID, (BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        public BinaryID id() {
            return ID;
        }

        public BinaryObject create() {
            return new AtomGroup();
        }

        public void encode(Encoder e, BinaryObject obj) throws IOException {
            AtomGroup o = (AtomGroup)obj;
            e.string(o.myName);
            e.value((BinaryObject)o.myRange);
            e.uint32((long)o.mySubGroups.length);
            for (int i = 0; i < o.mySubGroups.length; ++i) {
                e.value((BinaryObject)o.mySubGroups[i]);
            }
        }

        public void decode(Decoder d, BinaryObject obj) throws IOException {
            AtomGroup o = (AtomGroup)obj;
            o.myName = d.string();
            o.myRange = new Range();
            d.value((BinaryObject)o.myRange);
            AtomGroup.access$202(o, new AtomGroup[d.uint32()]);
            for (int i = 0; i < o.mySubGroups.length; ++i) {
                ((AtomGroup)o).mySubGroups[i] = new AtomGroup();
                d.value((BinaryObject)o.mySubGroups[i]);
            }
        }
    }
}

