/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.image;

import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.image.FmtRGBA;
import com.android.tools.idea.editors.gfxtrace.service.image.ImageInfo;
import com.android.tools.idea.editors.gfxtrace.service.path.AsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import javax.swing.ImageIcon;

public class FetchedImage {
    private static final Logger LOG = Logger.getInstance(FetchedImage.class);
    public final ImageInfo myImageInfo;
    public final byte[] myData;
    public final Dimension dimensions;
    public final ImageIcon icon;

    public static ListenableFuture<FetchedImage> load(final ServiceClient client, final Path imagePath) {
        return Futures.transform(client.get(imagePath), (AsyncFunction)new AsyncFunction<Object, FetchedImage>(){

            public ListenableFuture<FetchedImage> apply(Object object) throws Exception {
                assert (object instanceof ImageInfo);
                ImageInfo imageInfo = (ImageInfo)object;
                if (imageInfo.getFormat() instanceof FmtRGBA) {
                    return FetchedImage.load(client, imageInfo);
                }
                AsPath asPath = new AsPath().setObject(imagePath).setType(new FmtRGBA());
                return Futures.transform(client.get(asPath), (AsyncFunction)new AsyncFunction<Object, FetchedImage>(){

                    public ListenableFuture<FetchedImage> apply(Object object) throws Exception {
                        assert (object instanceof ImageInfo);
                        return FetchedImage.load(client, (ImageInfo)object);
                    }
                });
            }
        });
    }

    private static ListenableFuture<FetchedImage> load(ServiceClient client, final ImageInfo imageInfo) {
        return Futures.transform(client.get(imageInfo.getData()), (Function)new Function<byte[], FetchedImage>(){

            public FetchedImage apply(byte[] data) {
                return new FetchedImage(imageInfo, data);
            }
        });
    }

    public FetchedImage(ImageInfo imageInfo, byte[] data) {
        this.myImageInfo = imageInfo;
        this.myData = data;
        this.dimensions = new Dimension(this.myImageInfo.getWidth(), this.myImageInfo.getHeight());
        BufferedImage image = new BufferedImage(this.dimensions.width, this.dimensions.height, 7);
        WritableRaster raster = image.getRaster();
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        assert (this.myImageInfo.getFormat() instanceof FmtRGBA);
        int stride = this.dimensions.width * 4;
        int length = stride * this.dimensions.height;
        byte[] destination = dataBuffer.getData();
        assert (destination.length >= length);
        for (int y = 0; y < this.dimensions.height; ++y) {
            int yOffsetSource = stride * y;
            int yOffsetDestination = length - stride - yOffsetSource;
            for (int x = 0; x < stride; x += 4) {
                int destinationOffset = yOffsetDestination + x;
                int sourceOffset = yOffsetSource + x;
                destination[destinationOffset] = -1;
                destination[destinationOffset + 1] = data[sourceOffset + 2];
                destination[destinationOffset + 2] = data[sourceOffset + 1];
                destination[destinationOffset + 3] = data[sourceOffset];
            }
        }
        this.icon = new ImageIcon(image);
    }
}

