/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import java.io.IOException;

public final class MemoryRangePath
extends Path {
    private AtomPath myAfter;
    private long myPool;
    private long myAddress;
    private long mySize;
    private static final byte[] IDBytes = new byte[]{104, 109, -113, -31, -117, 52, 82, -65, -86, 11, 60, -32, 8, -26, -41, 6, 110, 96, 9, -35};
    public static final BinaryID ID = new BinaryID(IDBytes);

    @Override
    public StringBuilder stringPath(StringBuilder builder) {
        return this.myAfter.stringPath(builder).append("<").append(this.myPool).append(">").append("[").append(Long.toHexString(this.myAddress)).append(":").append(Long.toHexString(this.getEndAddress())).append("]");
    }

    public long getEndAddress() {
        return this.myAddress + this.mySize - 1L;
    }

    public AtomPath getAfter() {
        return this.myAfter;
    }

    public MemoryRangePath setAfter(AtomPath v) {
        this.myAfter = v;
        return this;
    }

    public long getPool() {
        return this.myPool;
    }

    public MemoryRangePath setPool(long v) {
        this.myPool = v;
        return this;
    }

    public long getAddress() {
        return this.myAddress;
    }

    public MemoryRangePath setAddress(long v) {
        this.myAddress = v;
        return this;
    }

    public long getSize() {
        return this.mySize;
    }

    public MemoryRangePath setSize(long v) {
        this.mySize = v;
        return this;
    }

    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static {
        Namespace.register((BinaryID)ID, (BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        public BinaryID id() {
            return ID;
        }

        public BinaryObject create() {
            return new MemoryRangePath();
        }

        public void encode(Encoder e, BinaryObject obj) throws IOException {
            MemoryRangePath o = (MemoryRangePath)obj;
            e.object((BinaryObject)o.myAfter);
            e.uint64(o.myPool);
            e.uint64(o.myAddress);
            e.uint64(o.mySize);
        }

        public void decode(Decoder d, BinaryObject obj) throws IOException {
            MemoryRangePath o = (MemoryRangePath)obj;
            o.myAfter = (AtomPath)d.object();
            o.myPool = d.uint64();
            o.myAddress = d.uint64();
            o.mySize = d.uint64();
        }
    }
}

