/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.editors.hprof.HprofViewPanel;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.captures.MemoryMappedFileBuffer;
import com.android.tools.perflib.heap.Snapshot;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class HprofEditor
extends UserDataHolderBase
implements FileEditor {
    private static final Logger LOG = Logger.getInstance(HprofEditor.class);
    private Snapshot mySnapshot;
    private JPanel myPanel = new JPanel();
    private boolean myIsValid = true;

    public HprofEditor(Project project, VirtualFile file) {
        this.parseHprofFileInBackground(project, file);
    }

    private void parseHprofFileInBackground(final Project project, final VirtualFile file) {
        TaskInfo taskInfo = new TaskInfo(){

            public String getTitle() {
                return "";
            }

            public String getCancelText() {
                return null;
            }

            public String getCancelTooltipText() {
                return null;
            }

            public boolean isCancellable() {
                return false;
            }

            public String getProcessId() {
                return null;
            }
        };
        final InlineProgressIndicator indicator = new InlineProgressIndicator(true, taskInfo){

            protected void queueProgressUpdate(Runnable update) {
                ApplicationManager.getApplication().invokeLater(update);
            }

            protected void queueRunningUpdate(Runnable update) {
                ApplicationManager.getApplication().invokeLater(update);
            }
        };
        JPanel indicatorWrapper = new JPanel();
        indicatorWrapper.add(indicator.getComponent());
        this.myPanel.setLayout(new GridBagLayout());
        this.myPanel.add(indicatorWrapper);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File hprofFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    indicator.setFraction(0.0);
                    indicator.setText("Parsing hprof file...");
                    HprofEditor.this.mySnapshot = Snapshot.createSnapshot((DataBuffer)new MemoryMappedFileBuffer(hprofFile));
                    indicator.setFraction(0.5);
                    indicator.setText("Computing dominators...");
                    HprofEditor.this.mySnapshot.computeDominators();
                }
                catch (Throwable throwable) {
                    try {
                        LOG.info(throwable);
                        final String errorMessage = "Unexpected error while processing hprof file: " + Throwables.getRootCause((Throwable)throwable).getMessage();
                        indicator.cancel();
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showErrorDialog((Project)project, (String)errorMessage, (String)HprofEditor.this.getName());
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HprofEditor.this.myPanel.removeAll();
                                HprofEditor.this.myPanel.setLayout(new BorderLayout());
                                if (HprofEditor.this.mySnapshot != null) {
                                    HprofViewPanel view = new HprofViewPanel(project, HprofEditor.this, HprofEditor.this.mySnapshot);
                                    Disposer.register((Disposable)HprofEditor.this, (Disposable)view);
                                    HprofEditor.this.myPanel.add((Component)view.getComponent(), "Center");
                                }
                            }
                        });
                        throw throwable2;
                    }
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getName() {
        return "HprofView";
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public void setInvalid() {
        this.myIsValid = false;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.mySnapshot.dispose();
        this.mySnapshot = null;
        this.myPanel = null;
        this.myIsValid = false;
    }
}

