/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.editors.hprof.HprofEditor;
import com.android.tools.idea.editors.hprof.views.ClassesTreeView;
import com.android.tools.idea.editors.hprof.views.InstanceReferenceTreeView;
import com.android.tools.idea.editors.hprof.views.InstancesTreeView;
import com.android.tools.idea.editors.hprof.views.SelectionModel;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Snapshot;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class HprofViewPanel
implements Disposable {
    public static final String TOOLBAR_NAME = "HprofActionToolbar";
    private static final int DIVIDER_WIDTH = 4;
    private JPanel myContainer;
    private Snapshot mySnapshot;
    private SelectionModel mySelectionModel;

    public HprofViewPanel(Project project, HprofEditor editor, Snapshot snapshot) {
        JBPanel treePanel = new JBPanel((LayoutManager)new BorderLayout());
        treePanel.setBackground(JBColor.background());
        this.mySnapshot = snapshot;
        assert (this.mySnapshot.getHeaps().size() > 0);
        Heap currentHeap = null;
        for (Heap heap : this.mySnapshot.getHeaps()) {
            if ("app".equals(heap.getName())) {
                currentHeap = heap;
                break;
            }
            if (currentHeap != null) continue;
            currentHeap = heap;
        }
        if (currentHeap == null) {
            editor.setInvalid();
            throw new IllegalStateException("Invalid heap given to HprofViewPanel.");
        }
        this.mySelectionModel = new SelectionModel(currentHeap);
        Disposer.register((Disposable)this, (Disposable)this.mySelectionModel);
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ComboBoxAction(){

            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                assert (HprofViewPanel.this.mySnapshot != null);
                for (final Heap heap : HprofViewPanel.this.mySnapshot.getHeaps()) {
                    if ("default".equals(heap.getName()) && heap.getClasses().isEmpty() && heap.getInstances().isEmpty()) continue;
                    group.add(new AnAction(heap.getName() + " heap"){

                        public void actionPerformed(AnActionEvent e) {
                            HprofViewPanel.this.mySelectionModel.setHeap(heap);
                        }
                    });
                }
                return group;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                this.getTemplatePresentation().setText(HprofViewPanel.this.mySelectionModel.getHeap().getName() + " heap");
                e.getPresentation().setText(HprofViewPanel.this.mySelectionModel.getHeap().getName() + " heap");
            }
        }});
        InstanceReferenceTreeView referenceTree = new InstanceReferenceTreeView(project, this.mySelectionModel);
        treePanel.add((Component)referenceTree.getComponent(), (Object)"Center");
        InstancesTreeView instancesTreeView = new InstancesTreeView(project, this.mySelectionModel);
        Disposer.register((Disposable)this, (Disposable)instancesTreeView);
        ClassesTreeView classesTreeView = new ClassesTreeView(project, group, this.mySelectionModel);
        JBSplitter splitter = HprofViewPanel.createNavigationSplitter(classesTreeView.getComponent(), instancesTreeView.getComponent());
        Disposer.register((Disposable)this, (Disposable)classesTreeView);
        JBPanel classPanel = new JBPanel((LayoutManager)new BorderLayout());
        classPanel.add((Component)splitter, (Object)"Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        toolbar.getComponent().setName(TOOLBAR_NAME);
        classPanel.add((Component)toolbar.getComponent(), (Object)"North");
        JBSplitter mainSplitter = new JBSplitter(true);
        mainSplitter.setFirstComponent((JComponent)classPanel);
        mainSplitter.setSecondComponent((JComponent)treePanel);
        mainSplitter.setDividerWidth(4);
        this.myContainer = new JPanel(new BorderLayout());
        this.myContainer.add((Component)mainSplitter);
    }

    public static JBSplitter createNavigationSplitter(JComponent leftPanelContents, JComponent rightPanelContents) {
        JBPanel navigationPanel = new JBPanel((LayoutManager)new BorderLayout());
        navigationPanel.setBackground(JBColor.background());
        if (leftPanelContents != null) {
            navigationPanel.add((Component)leftPanelContents, (Object)"Center");
        }
        JBPanel contextInformationPanel = new JBPanel((LayoutManager)new BorderLayout());
        contextInformationPanel.setBackground(JBColor.background());
        if (rightPanelContents != null) {
            contextInformationPanel.add((Component)rightPanelContents, (Object)"Center");
        }
        JBSplitter navigationSplitter = new JBSplitter(false);
        navigationSplitter.setFirstComponent((JComponent)navigationPanel);
        navigationSplitter.setSecondComponent((JComponent)contextInformationPanel);
        navigationSplitter.setDividerWidth(4);
        return navigationSplitter;
    }

    public JPanel getComponent() {
        return this.myContainer;
    }

    public void dispose() {
        this.myContainer.removeAll();
        this.mySnapshot = null;
    }
}

