/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.descriptors;

import com.android.tools.idea.editors.hprof.jdi.FieldImpl;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.Field;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.Value;
import java.util.List;

public abstract class HprofFieldDescriptorImpl
extends FieldDescriptorImpl {
    protected Field myField;
    protected Object myValueData;
    protected int myMemoryOrdering;

    public HprofFieldDescriptorImpl(Project project, Field field, Object value, int memoryOrdering) {
        super(project, null, (com.sun.jdi.Field)new FieldImpl(field, value));
        this.myField = field;
        this.myValueData = value;
        this.myMemoryOrdering = memoryOrdering;
    }

    public static void batchUpdateRepresentation(final List<HprofFieldDescriptorImpl> descriptors, DebuggerManagerThreadImpl debuggerManagerThread, final SuspendContextImpl suspendContext) {
        debuggerManagerThread.invokeAndWait(new DebuggerCommandImpl(){

            protected void action() throws Exception {
                for (HprofFieldDescriptorImpl descriptor : descriptors) {
                    descriptor.updateRepresentation(new EvaluationContextImpl(suspendContext, null, descriptor.getValue()), new DescriptorLabelListener(){

                        public void labelChanged() {
                        }
                    });
                }
            }
        });
    }

    public Object getValueData() {
        return this.myValueData;
    }

    public abstract Value calcValue(EvaluationContextImpl var1);

    public abstract Value getValue();

    public PsiExpression getDescriptorEvaluation(DebuggerContext context) {
        return null;
    }

    public Field getHprofField() {
        return this.myField;
    }

    public boolean isArray() {
        return this.myValueData instanceof ArrayInstance;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isLvalue() {
        return false;
    }

    public boolean isNull() {
        return this.myValueData == null;
    }

    public int getMemoryOrdering() {
        return this.myMemoryOrdering;
    }
}

