/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.descriptors;

import com.android.tools.idea.editors.hprof.descriptors.HprofFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.jdi.ArrayReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.ClassObjectReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.ObjectReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.StringReferenceImpl;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Type;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;

public class InstanceFieldDescriptorImpl
extends HprofFieldDescriptorImpl {
    private static final int MAX_VALUE_TEXT_LENGTH = 1024;
    private ObjectReferenceImpl myObjectReference = this.initObjectReference();
    private String myTruncatedValueText;

    public InstanceFieldDescriptorImpl(Project project, Field field, Instance instance, int memoryOrdering) {
        super(project, field, instance, memoryOrdering);
    }

    public Instance getInstance() {
        return (Instance)this.myValueData;
    }

    public boolean isString() {
        return this.myValueData != null && ((Instance)this.myValueData).getClassObj() != null && "java.lang.String".equals(((Instance)this.myValueData).getClassObj().getClassName());
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isExpandable() {
        if (this.myValueData instanceof ClassObj) {
            return false;
        }
        if (this.myValueData instanceof ArrayInstance) {
            return ((ArrayInstance)this.myValueData).getSize() > 0;
        }
        return !this.isNull();
    }

    @Override
    public Value getValue() {
        return this.calcValue(null);
    }

    public String getIdLabel() {
        Instance instance = this.getInstance();
        if (instance == null) {
            return "";
        }
        return String.format("%s (0x%x)", ValueDescriptorImpl.getIdLabel((ObjectReference)this.myObjectReference), instance.getUniqueId());
    }

    public String getValueText() {
        if (this.myTruncatedValueText != null) {
            return this.myTruncatedValueText;
        }
        if (this.myValueData == null) {
            this.myTruncatedValueText = "null";
        } else if (this.myValueData instanceof ClassObj) {
            this.myTruncatedValueText = String.format(" \"class %s\"", ((ClassObj)this.myValueData).getClassName());
        } else if (this.isString()) {
            int count = -1;
            int offset = 0;
            ArrayInstance charBufferArray = null;
            assert (this.myValueData instanceof ClassInstance);
            ClassInstance classInstance = (ClassInstance)this.myValueData;
            for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                if (charBufferArray == null && "value".equals(entry.getField().getName())) {
                    if (!(entry.getValue() instanceof ArrayInstance) || ((ArrayInstance)entry.getValue()).getArrayType() != Type.CHAR) continue;
                    charBufferArray = (ArrayInstance)entry.getValue();
                    continue;
                }
                if ("count".equals(entry.getField().getName())) {
                    if (!(entry.getValue() instanceof Integer)) continue;
                    count = (Integer)entry.getValue();
                    continue;
                }
                if (!"offset".equals(entry.getField().getName()) || !(entry.getValue() instanceof Integer)) continue;
                offset = (Integer)entry.getValue();
            }
            if (charBufferArray != null) {
                char[] stringChars = charBufferArray.asCharArray(offset >= 0 ? offset : 0, Math.max(Math.min(count, 1024), 0));
                int charLength = stringChars.length;
                StringBuilder builder = new StringBuilder(6 + charLength);
                builder.append(" \"");
                if (charLength == 1024) {
                    builder.append(stringChars, 0, charLength - 1).append("...");
                } else {
                    builder.append(stringChars);
                }
                builder.append("\"");
                this.myTruncatedValueText = builder.toString();
            } else {
                this.myTruncatedValueText = " ...<invalid string value>...";
            }
        } else {
            this.myTruncatedValueText = "";
        }
        return this.myTruncatedValueText;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) {
        return this.myObjectReference;
    }

    private ObjectReferenceImpl initObjectReference() {
        if (this.isString()) {
            return new StringReferenceImpl(this.myField, (Instance)this.myValueData);
        }
        if (this.myValueData instanceof ArrayInstance) {
            return new ArrayReferenceImpl(this.myField, (Instance)((ArrayInstance)this.myValueData));
        }
        if (this.myValueData instanceof ClassObj) {
            return new ClassObjectReferenceImpl(this.myField, (Instance)((ClassObj)this.myValueData));
        }
        return new ObjectReferenceImpl(this.myField, (Instance)this.myValueData);
    }
}

