/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.idea.actions.EditMultipleSourcesAction;
import com.android.tools.idea.actions.PsiFileAndLineNavigation;
import com.android.tools.idea.editors.allocations.ColumnTreeBuilder;
import com.android.tools.idea.editors.hprof.views.SelectionModel;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Type;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public class InstanceReferenceTreeView
implements DataProvider {
    public static final String TREE_NAME = "HprofInstanceReferenceTree";
    private static final int MAX_AUTO_EXPANSION_DEPTH = 5;
    private static final SimpleTextAttributes SOFT_REFERENCE_TEXT_ATTRIBUTE = new SimpleTextAttributes(2, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES.getFgColor());
    private static final Comparator<Instance> DEPTH_COMPARATOR = new Comparator<Instance>(){

        @Override
        public int compare(Instance o1, Instance o2) {
            return o1.getDistanceToGcRoot() - o2.getDistanceToGcRoot();
        }
    };
    private Project myProject;
    private Tree myTree;
    private JComponent myColumnTree;
    private Instance myInstance;

    public InstanceReferenceTreeView(Project project, SelectionModel selectionModel) {
        this.myProject = project;
        final TreeBuilder model = new TreeBuilder(null){

            public void buildChildren(TreeBuilderNode node) {
                if (node == this.getRoot()) {
                    node.add((MutableTreeNode)((Object)new InstanceNode(this, InstanceReferenceTreeView.this.myInstance, new String[0])));
                } else {
                    InstanceReferenceTreeView.this.addReferences((InstanceNode)node);
                }
                this.nodeChanged((TreeNode)node);
            }

            public boolean isExpandable(TreeBuilderNode node) {
                if (node == this.getRoot()) {
                    return node.getChildCount() > 0;
                }
                Instance instance = (Instance)node.getUserObject();
                return instance.getHardReferences().size() > 0 || instance.getSoftReferences() != null;
            }
        };
        model.setRoot(new TreeBuilderNode(null){

            protected TreeBuilder getTreeBuilder() {
                return model;
            }
        });
        this.myTree = new Tree((TreeModel)model);
        this.myTree.setName(TREE_NAME);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){
            private boolean myIsCurrentlyExpanding = false;

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                InstanceNode childNode;
                InstanceNode node;
                if (this.myIsCurrentlyExpanding) {
                    return;
                }
                this.myIsCurrentlyExpanding = true;
                InstanceNode currentNode = node = (InstanceNode)((Object)event.getPath().getLastPathComponent());
                for (int recursiveDepth = 5; currentNode.getChildCount() == 1 && recursiveDepth > 0 && !(childNode = (InstanceNode)((Object)currentNode.getChildAt(0))).isLeaf() && childNode.getInstance().getDistanceToGcRoot() != 0; --recursiveDepth) {
                    currentNode = childNode;
                    Instance currentInstance = currentNode.getInstance();
                    if (currentInstance.getDistanceToGcRoot() != 0) continue;
                    break;
                }
                if (node != currentNode) {
                    InstanceReferenceTreeView.this.myTree.expandPath(new TreePath(currentNode.getPath()));
                }
                this.myIsCurrentlyExpanding = false;
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.myTree.putClientProperty((Object)"DataProvider", (Object)this);
        JBList contextActionList = new JBList(new Object[]{new EditMultipleSourcesAction()});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)contextActionList);
        final DefaultActionGroup popupGroup = new DefaultActionGroup(new AnAction[]{new EditMultipleSourcesAction()});
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Reference Tree").setPreferredWidth(1200).setHeaderAlignment(2).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof InstanceNode) {
                    InstanceNode node = (InstanceNode)((Object)value);
                    Instance instance = node.getInstance();
                    String[] referenceVarNames = node.getVarNames();
                    if (referenceVarNames.length > 0) {
                        if (instance instanceof ArrayInstance) {
                            this.append(StringUtil.pluralize((String)"Index", (int)referenceVarNames.length), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                            this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                        StringBuilder builder = new StringBuilder();
                        builder.append(referenceVarNames[0]);
                        for (int i = 1; i < referenceVarNames.length; ++i) {
                            builder.append(", ");
                            builder.append(referenceVarNames[i]);
                        }
                        this.append(builder.toString(), instance.getIsSoftReference() ? SOFT_REFERENCE_TEXT_ATTRIBUTE : XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                        this.append(" in ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                    }
                    SimpleTextAttributes classTextAttributes = InstanceReferenceTreeView.this.myInstance.getImmediateDominator() == instance ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (instance.getIsSoftReference() ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : (instance.getDistanceToGcRoot() == 0 ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : (instance.getImmediateDominator() == null ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES)));
                    if (instance instanceof ArrayInstance) {
                        this.setIcon(AllIcons.Debugger.Db_array);
                    } else if (instance instanceof ClassObj) {
                        this.setIcon(PlatformIcons.FIELD_ICON);
                    } else {
                        this.setIcon(AllIcons.Debugger.Value);
                    }
                    if (InstanceReferenceTreeView.this.myInstance.getImmediateDominator() == instance || instance.getDistanceToGcRoot() == 0) {
                        int totalIcons = 1 + (InstanceReferenceTreeView.this.myInstance.getImmediateDominator() == instance ? 1 : 0) + (instance.getDistanceToGcRoot() == 0 ? 1 : 0);
                        RowIcon icons = new RowIcon(totalIcons);
                        icons.setIcon(this.getIcon(), 0);
                        int currentIcon = 1;
                        if (InstanceReferenceTreeView.this.myInstance.getImmediateDominator() == instance) {
                            icons.setIcon(AllIcons.Hierarchy.Class, currentIcon++);
                        }
                        if (instance.getDistanceToGcRoot() == 0) {
                            icons.setIcon(AllIcons.Hierarchy.Subtypes, currentIcon);
                        }
                        this.setIcon((Icon)icons);
                    }
                    this.append(instance.toString(), classTextAttributes);
                } else if (value != null) {
                    this.append(StringUtil.notNullize((String)value.toString()), SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Depth").setPreferredWidth(40).setHeaderAlignment(4).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof InstanceNode) {
                    Instance instance = ((InstanceNode)((Object)value)).getInstance();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getDistanceToGcRoot()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    this.setTextAlign(4);
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Shallow Size").setPreferredWidth(80).setHeaderAlignment(4).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof InstanceNode) {
                    Instance instance = ((InstanceNode)((Object)value)).getInstance();
                    if (instance != null) {
                        this.append(String.valueOf(instance.getSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    this.setTextAlign(4);
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Dominating Size").setPreferredWidth(80).setHeaderAlignment(4).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof InstanceNode) {
                    Instance instance = ((InstanceNode)((Object)value)).getInstance();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getTotalRetainedSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    this.setTextAlign(4);
                }
            }
        }));
        this.myColumnTree = builder.build();
        selectionModel.addListener(new SelectionModel.SelectionListener(){

            @Override
            public void onHeapChanged(Heap heap) {
                InstanceReferenceTreeView.this.clearInstance();
            }

            @Override
            public void onClassObjChanged(ClassObj classObj) {
                InstanceReferenceTreeView.this.clearInstance();
            }

            @Override
            public void onInstanceChanged(Instance instance) {
                if (instance == null) {
                    InstanceReferenceTreeView.this.clearInstance();
                } else {
                    InstanceReferenceTreeView.this.myInstance = instance;
                    TreeBuilder model = InstanceReferenceTreeView.this.getMutableModel();
                    TreeBuilderNode root = (TreeBuilderNode)model.getRoot();
                    root.removeAllChildren();
                    root.add((MutableTreeNode)((Object)new InstanceNode(InstanceReferenceTreeView.this.getMutableModel(), instance, new String[0])));
                    model.nodeStructureChanged((TreeNode)((TreeBuilderNode)model.getRoot()));
                    InstanceReferenceTreeView.this.myTree.expandRow(0);
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.myColumnTree;
    }

    private void clearInstance() {
        TreeBuilderNode root = (TreeBuilderNode)this.getMutableModel().getRoot();
        root.removeAllChildren();
        this.getMutableModel().nodeStructureChanged((TreeNode)root);
    }

    private TreeBuilder getMutableModel() {
        return (TreeBuilder)this.myTree.getModel();
    }

    private void addReferences(InstanceNode node) {
        Instance instance = node.getInstance();
        if (instance instanceof RootObj) {
            return;
        }
        ArrayList sortedReferences = new ArrayList(instance.getHardReferences());
        Collections.sort(sortedReferences, DEPTH_COMPARATOR);
        if (instance.getSoftReferences() != null) {
            ArrayList sortedSoftReferences = new ArrayList(instance.getSoftReferences());
            Collections.sort(sortedSoftReferences, DEPTH_COMPARATOR);
            sortedReferences.addAll(sortedSoftReferences);
        }
        for (Instance reference : sortedReferences) {
            ArrayList<String> scratchList = new ArrayList<String>(3);
            if (reference instanceof ClassInstance) {
                ClassInstance classInstance = (ClassInstance)reference;
                for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                    if (entry.getField().getType() != Type.OBJECT || entry.getValue() != instance) continue;
                    scratchList.add(entry.getField().getName());
                }
            } else if (reference instanceof ArrayInstance) {
                ArrayInstance arrayInstance = (ArrayInstance)reference;
                assert (arrayInstance.getArrayType() == Type.OBJECT);
                Object[] values = arrayInstance.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != instance) continue;
                    scratchList.add(String.valueOf(i));
                }
            } else if (reference instanceof ClassObj) {
                ClassObj classObj = (ClassObj)reference;
                Map staticValues = classObj.getStaticFieldValues();
                for (Map.Entry entry : staticValues.entrySet()) {
                    if (((Field)entry.getKey()).getType() != Type.OBJECT || entry.getValue() != instance) continue;
                    scratchList.add(((Field)entry.getKey()).getName());
                }
            }
            String[] scratchNameArray = new String[scratchList.size()];
            node.add((MutableTreeNode)((Object)new InstanceNode(this.getMutableModel(), reference, scratchList.toArray(scratchNameArray))));
        }
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getTargetFiles();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private PsiFileAndLineNavigation[] getTargetFiles() {
        Object node = this.myTree.getSelectionPath().getLastPathComponent();
        String className = null;
        if (node instanceof InstanceNode) {
            Instance instance = ((InstanceNode)((Object)node)).getInstance();
            if (instance instanceof ClassObj) {
                className = ((ClassObj)instance).getClassName();
            } else {
                className = instance.getClassObj().getClassName();
                if (instance instanceof ArrayInstance) {
                    className = className.replace("[]", "");
                }
            }
        }
        return PsiFileAndLineNavigation.wrappersForClassName(this.myProject, className, 0);
    }

    private static class InstanceNode
    extends TreeBuilderNode {
        private TreeBuilder myModel;
        private String[] myVarNames;

        public InstanceNode(TreeBuilder model, Instance userObject, String ... varNames) {
            super((Object)userObject);
            this.myModel = model;
            this.myVarNames = varNames;
        }

        public String[] getVarNames() {
            return this.myVarNames;
        }

        public Instance getInstance() {
            return (Instance)this.getUserObject();
        }

        protected TreeBuilder getTreeBuilder() {
            return this.myModel;
        }
    }
}

