/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.idea.actions.EditMultipleSourcesAction;
import com.android.tools.idea.actions.PsiFileAndLineNavigation;
import com.android.tools.idea.editors.allocations.ColumnTreeBuilder;
import com.android.tools.idea.editors.hprof.descriptors.ContainerDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.ExpansionDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.HprofFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.InstanceFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.PrimitiveFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.views.SelectionModel;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Type;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.DefaultNodeDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public class InstancesTreeView
implements DataProvider,
Disposable {
    public static final String TREE_NAME = "HprofInstancesTree";
    private static final int NODES_PER_EXPANSION = 100;
    private Project myProject;
    private DebuggerTree myDebuggerTree;
    private JComponent myColumnTree;
    private DebugProcessImpl myDebugProcess;
    private volatile SuspendContextImpl myDummySuspendContext;
    private Heap myHeap;
    private ClassObj myClassObj;
    private Comparator<DebuggerTreeNodeImpl> myComparator;
    private SortOrder mySortOrder = SortOrder.UNSORTED;

    public InstancesTreeView(Project project, final SelectionModel selectionModel) {
        this.myProject = project;
        this.myDebuggerTree = new DebuggerTree(project){

            protected void build(DebuggerContextImpl context) {
                DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
                Instance instance = ((InstanceFieldDescriptorImpl)root.getDescriptor()).getInstance();
                InstancesTreeView.this.addChildren(root, null, instance);
            }

            public Object getData(@NonNls String dataId) {
                return InstancesTreeView.this.getData(dataId);
            }
        };
        this.myDebuggerTree.getComponent().setName(TREE_NAME);
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myDebuggerTree);
        this.myHeap = selectionModel.getHeap();
        this.myDebugProcess = new DebugProcessEvents(project);
        final SuspendManagerImpl suspendManager = new SuspendManagerImpl(this.myDebugProcess);
        this.myDebugProcess.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

            protected void action() throws Exception {
                InstancesTreeView.this.myDummySuspendContext = suspendManager.pushSuspendContext(0, 1);
            }
        });
        TreeBuilder model = new TreeBuilder(this.myDebuggerTree){

            public void buildChildren(TreeBuilderNode node) {
                DebuggerTreeNodeImpl debuggerTreeNode = (DebuggerTreeNodeImpl)node;
                NodeDescriptorImpl descriptor = debuggerTreeNode.getDescriptor();
                if (descriptor instanceof DefaultNodeDescriptor) {
                    return;
                }
                if (descriptor instanceof ContainerDescriptorImpl) {
                    InstancesTreeView.this.addContainerChildren(debuggerTreeNode, 0);
                } else {
                    InstanceFieldDescriptorImpl instanceDescriptor = (InstanceFieldDescriptorImpl)descriptor;
                    InstancesTreeView.this.addChildren(debuggerTreeNode, instanceDescriptor.getHprofField(), instanceDescriptor.getInstance());
                }
                InstancesTreeView.this.sortTree(debuggerTreeNode);
                InstancesTreeView.this.myDebuggerTree.treeDidChange();
            }

            public boolean isExpandable(TreeBuilderNode builderNode) {
                return ((DebuggerTreeNodeImpl)builderNode).getDescriptor().isExpandable();
            }
        };
        model.setRoot((TreeBuilderNode)this.myDebuggerTree.getNodeFactory().getDefaultNode());
        model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent event) {
                InstancesTreeView.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent event) {
                InstancesTreeView.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent event) {
                InstancesTreeView.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent event) {
                InstancesTreeView.this.myDebuggerTree.hideTooltip();
            }
        });
        this.myDebuggerTree.setModel((TreeModel)model);
        this.myDebuggerTree.setRootVisible(false);
        this.myDebuggerTree.putClientProperty((Object)"DataProvider", (Object)this);
        JBList contextActionList = new JBList(new Object[]{new EditMultipleSourcesAction()});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)contextActionList);
        final DefaultActionGroup popupGroup = new DefaultActionGroup(new AnAction[]{new EditMultipleSourcesAction()});
        this.myDebuggerTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }
        });
        selectionModel.addListener(new SelectionModel.SelectionListener(){

            @Override
            public void onHeapChanged(Heap heap) {
                if (heap != InstancesTreeView.this.myHeap) {
                    InstancesTreeView.this.myHeap = heap;
                    if (InstancesTreeView.this.myDebuggerTree.getMutableModel().getRoot() != null) {
                        this.onSelectionChanged();
                    }
                }
            }

            @Override
            public void onClassObjChanged(ClassObj classObj) {
                if (classObj != InstancesTreeView.this.myClassObj) {
                    InstancesTreeView.this.myClassObj = classObj;
                    this.onSelectionChanged();
                }
            }

            @Override
            public void onInstanceChanged(Instance instance) {
            }

            private void onSelectionChanged() {
                DebuggerTreeNodeImpl newRoot;
                Instance singleChild = null;
                if (InstancesTreeView.this.myClassObj != null) {
                    ContainerDescriptorImpl containerDescriptor = new ContainerDescriptorImpl(InstancesTreeView.this.myClassObj, InstancesTreeView.this.myHeap.getId());
                    newRoot = DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)InstancesTreeView.this.myDebuggerTree, (NodeDescriptor)containerDescriptor);
                    if (containerDescriptor.getInstances().size() == 1) {
                        singleChild = containerDescriptor.getInstances().get(0);
                    }
                } else {
                    newRoot = InstancesTreeView.this.myDebuggerTree.getNodeFactory().getDefaultNode();
                }
                InstancesTreeView.this.myDebuggerTree.getMutableModel().setRoot((TreeBuilderNode)newRoot);
                InstancesTreeView.this.myDebuggerTree.treeChanged();
                if (InstancesTreeView.this.myDebuggerTree.getRowCount() > 0) {
                    InstancesTreeView.this.myDebuggerTree.scrollRowToVisible(0);
                }
                if (singleChild != null) {
                    InstancesTreeView.this.myDebuggerTree.setSelectionInterval(0, 0);
                    selectionModel.setInstance(singleChild);
                }
            }
        });
        this.myDebuggerTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DebuggerTreeNodeImpl lastPathNode;
                TreePath path = e.getPath();
                if (path == null || path.getPathCount() < 2 || !e.isAddedPath()) {
                    selectionModel.setInstance(null);
                    return;
                }
                DebuggerTreeNodeImpl instanceNode = (DebuggerTreeNodeImpl)path.getPathComponent(1);
                if (instanceNode.getDescriptor() instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)instanceNode.getDescriptor();
                    selectionModel.setInstance(descriptor.getInstance());
                }
                if ((lastPathNode = (DebuggerTreeNodeImpl)path.getLastPathComponent()).getDescriptor() instanceof ExpansionDescriptorImpl) {
                    ExpansionDescriptorImpl expansionDescriptor = (ExpansionDescriptorImpl)lastPathNode.getDescriptor();
                    DebuggerTreeNodeImpl parentNode = lastPathNode.getParent();
                    InstancesTreeView.this.myDebuggerTree.getMutableModel().removeNodeFromParent((TreeBuilderNode)lastPathNode);
                    if (parentNode.getDescriptor() instanceof ContainerDescriptorImpl) {
                        InstancesTreeView.this.addContainerChildren(parentNode, expansionDescriptor.getStartIndex());
                    } else if (parentNode.getDescriptor() instanceof InstanceFieldDescriptorImpl) {
                        InstanceFieldDescriptorImpl instanceFieldDescriptor = (InstanceFieldDescriptorImpl)parentNode.getDescriptor();
                        InstancesTreeView.this.addChildren(parentNode, instanceFieldDescriptor.getHprofField(), instanceFieldDescriptor.getInstance(), expansionDescriptor.getStartIndex());
                    }
                    InstancesTreeView.this.sortTree(parentNode);
                    InstancesTreeView.this.myDebuggerTree.getMutableModel().nodeStructureChanged((TreeNode)parentNode);
                    if (InstancesTreeView.this.myComparator != null) {
                        InstancesTreeView.this.myDebuggerTree.scrollPathToVisible(new TreePath(((DebuggerTreeNodeImpl)parentNode.getLastChild()).getPath()));
                    }
                }
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myDebuggerTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Instance").setPreferredWidth(600).setHeaderAlignment(2).setComparator(new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(DebuggerTreeNodeImpl a, DebuggerTreeNodeImpl b) {
                return InstancesTreeView.this.getDefaultOrdering(a, b);
            }
        }).setRenderer((ColoredTreeCellRenderer)((DebuggerTreeRenderer)this.myDebuggerTree.getCellRenderer()))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Depth").setPreferredWidth(60).setHeaderAlignment(4).setComparator(new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(DebuggerTreeNodeImpl a, DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                int depthA = 0;
                int depthB = 0;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null) {
                    depthA = instanceA.getDistanceToGcRoot();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null) {
                    depthB = instanceB.getDistanceToGcRoot();
                }
                if (depthA != depthB) {
                    return depthA - depthB;
                }
                return InstancesTreeView.this.getDefaultOrdering(a, b);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                NodeDescriptorImpl nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject();
                if (nodeDescriptor instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getDistanceToGcRoot()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Shallow Size").setPreferredWidth(80).setHeaderAlignment(4).setComparator(new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(DebuggerTreeNodeImpl a, DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                int sizeA = 0;
                int sizeB = 0;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null) {
                    sizeA = instanceA.getSize();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null) {
                    sizeB = instanceB.getSize();
                }
                if (sizeA != sizeB) {
                    return sizeA - sizeB;
                }
                return InstancesTreeView.this.getDefaultOrdering(a, b);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                NodeDescriptorImpl nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject();
                if (nodeDescriptor instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null) {
                        this.append(String.valueOf(instance.getSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Dominating Size").setPreferredWidth(80).setHeaderAlignment(4).setComparator(new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(DebuggerTreeNodeImpl a, DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                long sizeA = 0L;
                long sizeB = 0L;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null && instanceA.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                    sizeA = instanceA.getTotalRetainedSize();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null && instanceB.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                    sizeB = instanceB.getTotalRetainedSize();
                }
                if (sizeA != sizeB) {
                    return (int)(sizeA - sizeB);
                }
                return InstancesTreeView.this.getDefaultOrdering(a, b);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                NodeDescriptorImpl nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject();
                if (nodeDescriptor instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getTotalRetainedSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }
        }));
        builder.setTreeSorter(new ColumnTreeBuilder.TreeSorter<DebuggerTreeNodeImpl>(){

            @Override
            public void sort(Comparator<DebuggerTreeNodeImpl> comparator, SortOrder sortOrder) {
                if (InstancesTreeView.this.myComparator != comparator && InstancesTreeView.this.mySortOrder != sortOrder) {
                    InstancesTreeView.this.myComparator = comparator;
                    InstancesTreeView.this.mySortOrder = sortOrder;
                    TreeBuilder mutableModel = InstancesTreeView.this.myDebuggerTree.getMutableModel();
                    DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)mutableModel.getRoot();
                    InstancesTreeView.this.sortTree(root);
                    selectionModel.setSelectionLocked(true);
                    TreePath selectionPath = InstancesTreeView.this.myDebuggerTree.getSelectionPath();
                    mutableModel.nodeStructureChanged((TreeNode)root);
                    InstancesTreeView.this.myDebuggerTree.setSelectionPath(selectionPath);
                    InstancesTreeView.this.myDebuggerTree.scrollPathToVisible(selectionPath);
                    selectionModel.setSelectionLocked(false);
                }
            }
        });
        this.myColumnTree = builder.build();
    }

    public JComponent getComponent() {
        return this.myColumnTree;
    }

    private void sortTree(DebuggerTreeNodeImpl node) {
        if (this.myComparator == null) {
            return;
        }
        Enumeration e = node.rawChildren();
        if (e.hasMoreElements()) {
            ArrayList<DebuggerTreeNodeImpl> builtChildren = Collections.list(e);
            DebuggerTreeNodeImpl expansionNode = builtChildren.get(builtChildren.size() - 1);
            if (expansionNode.getDescriptor() instanceof ExpansionDescriptorImpl) {
                builtChildren.remove(builtChildren.size() - 1);
            } else {
                expansionNode = null;
            }
            Collections.sort(builtChildren, this.myComparator);
            node.removeAllChildren();
            for (DebuggerTreeNodeImpl childNode : builtChildren) {
                node.add((MutableTreeNode)childNode);
                this.sortTree(childNode);
            }
            if (expansionNode != null) {
                node.add((MutableTreeNode)expansionNode);
            }
        }
    }

    private int getDefaultOrdering(DebuggerTreeNodeImpl a, DebuggerTreeNodeImpl b) {
        Instance parentInstance;
        NodeDescriptorImpl parentDescriptor = a.getParent().getDescriptor();
        if (parentDescriptor instanceof InstanceFieldDescriptorImpl ? (parentInstance = ((InstanceFieldDescriptorImpl)parentDescriptor).getInstance()) instanceof ArrayInstance : parentDescriptor instanceof ContainerDescriptorImpl) {
            return this.getMemoryOrderingSortResult(a, b);
        }
        return a.getDescriptor().getLabel().compareTo(b.getDescriptor().getLabel());
    }

    private int getMemoryOrderingSortResult(DebuggerTreeNodeImpl a, DebuggerTreeNodeImpl b) {
        return ((HprofFieldDescriptorImpl)a.getDescriptor()).getMemoryOrdering() - ((HprofFieldDescriptorImpl)b.getDescriptor()).getMemoryOrdering() ^ (this.mySortOrder == SortOrder.ASCENDING ? 1 : -1);
    }

    private void addContainerChildren(DebuggerTreeNodeImpl node, int startIndex) {
        ContainerDescriptorImpl containerDescriptor = (ContainerDescriptorImpl)node.getDescriptor();
        List<Instance> instances = containerDescriptor.getInstances();
        ArrayList<HprofFieldDescriptorImpl> descriptors = new ArrayList<HprofFieldDescriptorImpl>(100);
        int currentIndex = startIndex;
        int limit = currentIndex + 100;
        for (int loopCounter = currentIndex; loopCounter < instances.size() && currentIndex < limit; ++loopCounter) {
            Instance instance = instances.get(loopCounter);
            if (this.myHeap.getInstance(instance.getId()) == null) continue;
            descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(Type.OBJECT, Integer.toString(currentIndex)), instance, currentIndex));
            ++currentIndex;
        }
        HprofFieldDescriptorImpl.batchUpdateRepresentation(descriptors, this.myDebugProcess.getManagerThread(), this.myDummySuspendContext);
        for (HprofFieldDescriptorImpl descriptor : descriptors) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)descriptor));
        }
        if (currentIndex == limit) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)new ExpansionDescriptorImpl("instances", limit, instances.size())));
        }
    }

    private void addChildren(DebuggerTreeNodeImpl node, Field field, Instance instance) {
        this.addChildren(node, field, instance, 0);
    }

    private void addChildren(DebuggerTreeNodeImpl node, Field field, Instance instance, int arrayStartIndex) {
        ArrayList<HprofFieldDescriptorImpl> descriptors;
        int currentArrayIndex;
        if (instance == null) {
            return;
        }
        int limit = currentArrayIndex + 100;
        int arrayLength = 0;
        if (instance instanceof ClassInstance) {
            ClassInstance classInstance = (ClassInstance)instance;
            descriptors = new ArrayList<HprofFieldDescriptorImpl>(classInstance.getValues().size());
            int i = 0;
            for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                if (entry.getField().getType() == Type.OBJECT) {
                    descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), entry.getField(), (Instance)entry.getValue(), i));
                } else {
                    descriptors.add(new PrimitiveFieldDescriptorImpl(this.myDebuggerTree.getProject(), entry.getField(), entry.getValue(), i));
                }
                ++i;
            }
        } else if (instance instanceof ArrayInstance) {
            assert (field != null);
            ArrayInstance arrayInstance = (ArrayInstance)instance;
            Object[] values = arrayInstance.getValues();
            descriptors = new ArrayList(values.length);
            arrayLength = values.length;
            if (arrayInstance.getArrayType() == Type.OBJECT) {
                for (currentArrayIndex = arrayStartIndex; currentArrayIndex < arrayLength && currentArrayIndex < limit; ++currentArrayIndex) {
                    descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(arrayInstance.getArrayType(), String.valueOf(currentArrayIndex)), (Instance)values[currentArrayIndex], currentArrayIndex));
                }
            } else {
                while (currentArrayIndex < arrayLength && currentArrayIndex < limit) {
                    descriptors.add(new PrimitiveFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(arrayInstance.getArrayType(), String.valueOf(currentArrayIndex)), values[currentArrayIndex], currentArrayIndex));
                    ++currentArrayIndex;
                }
            }
        } else {
            throw new RuntimeException("Unimplemented Instance type in addChildren.");
        }
        HprofFieldDescriptorImpl.batchUpdateRepresentation(descriptors, this.myDebugProcess.getManagerThread(), this.myDummySuspendContext);
        for (HprofFieldDescriptorImpl descriptor : descriptors) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)descriptor));
        }
        if (currentArrayIndex == limit) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)new ExpansionDescriptorImpl("array elements", limit, arrayLength)));
        }
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getTargetFiles();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private PsiFileAndLineNavigation[] getTargetFiles() {
        Instance instance;
        NodeDescriptorImpl nodeDescriptor;
        Object node = this.myDebuggerTree.getSelectionPath().getLastPathComponent();
        String className = null;
        if (node instanceof DebuggerTreeNodeImpl && (nodeDescriptor = ((DebuggerTreeNodeImpl)node).getDescriptor()) instanceof InstanceFieldDescriptorImpl && (instance = ((InstanceFieldDescriptorImpl)nodeDescriptor).getInstance()) != null) {
            if (instance instanceof ClassObj) {
                className = ((ClassObj)instance).getClassName();
            } else {
                className = instance.getClassObj().getClassName();
                if (instance instanceof ArrayInstance) {
                    className = className.replace("[]", "");
                }
            }
        }
        return PsiFileAndLineNavigation.wrappersForClassName(this.myProject, className, 0);
    }

    public void dispose() {
        this.myDebugProcess.stop(true);
        this.myDebugProcess.dispose();
    }
}

