/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views.nodedata;

import com.android.tools.idea.editors.hprof.views.nodedata.HeapNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapPackageNode;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class HeapClassObjNode
implements HeapNode {
    private HeapNode myParent;
    private ClassObj myClassObj;
    private long myRetainedSize;
    private String mySimpleName;

    public HeapClassObjNode(ClassObj classObj, int heapId) {
        this.myClassObj = classObj;
        for (Instance instance : this.myClassObj.getHeapInstances(heapId)) {
            this.myRetainedSize += instance.getTotalRetainedSize();
        }
        this.mySimpleName = this.myClassObj.getClassName();
        int index = this.mySimpleName.lastIndexOf(46);
        if (index >= 0 && index < this.mySimpleName.length() - 1) {
            this.mySimpleName = this.mySimpleName.substring(index + 1, this.mySimpleName.length());
        }
    }

    public ClassObj getClassObj() {
        return this.myClassObj;
    }

    @Override
    public String getFullName() {
        return this.getClassObj().getClassName();
    }

    @Override
    public String getSimpleName() {
        return this.mySimpleName;
    }

    @Override
    public int getTotalCount() {
        return this.getClassObj().getInstanceCount();
    }

    @Override
    public int getHeapInstancesCount(int heapId) {
        return this.getClassObj().getHeapInstancesCount(heapId);
    }

    @Override
    public int getInstanceSize() {
        return this.getClassObj().getInstanceSize();
    }

    @Override
    public int getShallowSize(int heapId) {
        return this.getClassObj().getShallowSize(heapId);
    }

    @Override
    public long getRetainedSize() {
        return this.myRetainedSize;
    }

    @Override
    public void add(HeapNode heapNode) {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public List<HeapNode> getChildren() {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public void removeAllChildren() {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode node) {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        throw new RuntimeException("Invalid operation on " + this.getClass().getSimpleName());
    }

    @Override
    public void removeFromParent() {
        if (this.myParent != null) {
            assert (this.myParent instanceof HeapPackageNode);
            ((HeapPackageNode)this.myParent).remove(this);
            this.myParent = null;
        }
    }

    @Override
    public void setParent(HeapNode newParent) {
        assert (newParent == null || newParent instanceof HeapPackageNode);
        this.myParent = newParent;
    }
}

