/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.RenderingParameters;
import com.android.tools.idea.editors.navigation.Transform;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.android.tools.swing.layoutlib.FakeImageFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidRootComponent
extends JComponent {
    public static final boolean DEBUG = false;
    public static final int PADDING = JBUI.scale((int)3);
    private static final int ARC_SIZE = JBUI.scale((int)10);
    private static final Font FONT = UIUtil.getLabelFont();
    private static final FontMetrics FONT_METRICS = new Canvas().getFontMetrics(FONT);
    private final RenderingParameters myRenderingParameters;
    private final PsiFile myLayoutFile;
    private final String myMenuName;
    private final String myActivityName;
    Transform transform = new Transform(1.0f);
    private BufferedImage myScaledImage;
    private RenderResult myRenderResult = null;
    private boolean myRenderPending = false;
    private boolean mySelected = false;

    public static int getTopShift() {
        return PADDING + FONT_METRICS.getHeight();
    }

    public static Point relativePoint(Point p) {
        return new Point(p.x - PADDING, p.y - AndroidRootComponent.getTopShift());
    }

    public AndroidRootComponent(String className, RenderingParameters renderingParameters, PsiFile psiFile, String menuName) {
        int dotIndex = className.lastIndexOf(46);
        String activityName = dotIndex == -1 ? className : className.substring(dotIndex + 1);
        this.myActivityName = menuName == null ? activityName : activityName + " [menu]";
        this.myRenderingParameters = renderingParameters;
        this.myLayoutFile = psiFile;
        this.myMenuName = menuName;
    }

    public boolean isMenu() {
        return this.myMenuName != null;
    }

    public static void launchEditor(RenderingParameters renderingParameters, PsiFile file, boolean layoutFile) {
        if (file != null) {
            Project project = renderingParameters.project;
            VirtualFile virtualFile = file.getVirtualFile();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, 0);
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            manager.openEditor(descriptor, true);
            if (layoutFile) {
                manager.setSelectedEditor(virtualFile, "android-designer");
            }
        }
    }

    public void launchLayoutEditor() {
        AndroidRootComponent.launchEditor(this.myRenderingParameters, this.myLayoutFile, true);
    }

    public RenderResult getRenderResult() {
        return this.myRenderResult;
    }

    private void setRenderResult(RenderResult renderResult) {
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        this.myRenderResult = renderResult;
        this.revalidate();
        parent.repaint();
    }

    private void invalidate2() {
        this.myScaledImage = null;
    }

    public void setScale(float scale) {
        this.transform = new Transform(scale);
        this.invalidate2();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.transform.modelToView(this.myRenderingParameters.getDeviceScreenSize());
        return new Dimension(d.width + 2 * PADDING, d.height + 2 * PADDING + FONT_METRICS.getHeight());
    }

    private BufferedImage getScaledImage() {
        return this.myScaledImage;
    }

    private void center(Graphics g, String message, Font font, int height) {
        int messageWidth = this.getFontMetrics(font).stringWidth(message);
        g.drawString(message, (this.getWidth() - messageWidth) / 2, height);
    }

    private Color getBackgroundColor() {
        if (this.mySelected) {
            return JBColor.BLUE;
        }
        return Gray._30;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    @Override
    public void paintComponent(Graphics g) {
        GraphicsUtil.setupAAPainting((Graphics)g);
        g.setColor(this.getBackgroundColor());
        Dimension size = this.getSize();
        g.fillRoundRect(0, 0, size.width, size.height, ARC_SIZE, ARC_SIZE);
        g.setColor((Color)JBColor.WHITE);
        BufferedImage scaledImage = this.getScaledImage();
        if (scaledImage != null) {
            g.setFont(FONT);
            g.drawString(this.myActivityName, PADDING, PADDING + FONT_METRICS.getAscent());
            g.drawImage(scaledImage, PADDING, AndroidRootComponent.getTopShift(), null);
        } else {
            Font font = g.getFont();
            int vCenter = this.getHeight() / 2;
            String message = "[" + (this.myLayoutFile == null ? "no xml resource" : this.myLayoutFile.getName()) + "]";
            this.center(g, message, font, vCenter);
            this.render(this.transform.myScale);
        }
    }

    private void render(final float scale) {
        if (this.myLayoutFile == null) {
            return;
        }
        Project project = this.myRenderingParameters.project;
        final AndroidFacet facet = this.myRenderingParameters.facet;
        final Configuration configuration = this.myRenderingParameters.configuration;
        if (project.isDisposed()) {
            return;
        }
        if (this.myRenderPending) {
            return;
        }
        this.myRenderPending = true;
        ActionBarHandler.showMenu(true, null, false);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                RenderService renderService = RenderService.get(facet);
                RenderTask task = renderService.createTask(AndroidRootComponent.this.myLayoutFile, configuration, renderService.createLogger(), null);
                if (task != null) {
                    Result result;
                    RenderSession session;
                    task.setProvideCookiesForIncludedViews(true);
                    ActionBarHandler actionBarHandler = task.getLayoutlibCallback().getActionBarHandler();
                    if (actionBarHandler != null) {
                        List<String> menuList = AndroidRootComponent.this.isMenu() ? Collections.singletonList(AndroidRootComponent.this.myMenuName) : Collections.emptyList();
                        actionBarHandler.setMenuIdNames(menuList);
                    }
                    FakeImageFactory factory = new FakeImageFactory();
                    Dimension size = AndroidRootComponent.this.getSize();
                    BufferedImage image = UIUtil.createImage((int)(size.width - 2 * PADDING), (int)(size.height - 2 * PADDING), (int)2);
                    Graphics2D graphics = (Graphics2D)image.getGraphics();
                    graphics.setTransform(AffineTransform.getScaleInstance(scale, scale));
                    factory.setGraphics(graphics);
                    RenderResult renderedResult = task.render(factory);
                    if (renderedResult != null && (session = renderedResult.getSession()) != null && (result = session.getResult()).isSuccess()) {
                        AndroidRootComponent.this.setRenderResult(renderedResult);
                        AndroidRootComponent.this.myScaledImage = image;
                        task.dispose();
                        AndroidRootComponent.this.myRenderPending = false;
                        return;
                    }
                }
            }
        });
    }

    public RenderedView getRenderedView(Point p) {
        RenderResult renderResult = this.getRenderResult();
        if (renderResult == null) {
            return null;
        }
        RenderedViewHierarchy hierarchy = renderResult.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.findLeafAt(this.transform.viewToModelX(p.x), this.transform.viewToModelY(p.y));
    }
}

