/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.NavigationEditorUtils;
import com.android.tools.idea.editors.navigation.Transform;
import com.android.tools.idea.editors.navigation.model.ModelDimension;
import com.intellij.openapi.project.Project;
import java.awt.Dimension;
import org.jetbrains.android.facet.AndroidFacet;

public class RenderingParameters {
    public final Project project;
    public final AndroidFacet facet;
    public final Configuration configuration;

    public RenderingParameters(AndroidFacet facet, Configuration configuration) {
        this.project = facet.getModule().getProject();
        this.facet = facet;
        this.configuration = configuration;
    }

    public RenderingParameters withConfiguration(Configuration configuration) {
        return new RenderingParameters(this.facet, configuration);
    }

    ModelDimension getDeviceScreenSize() {
        return ModelDimension.create(this.getDeviceScreenSize1());
    }

    private Dimension getDeviceScreenSize1() {
        Device device = this.configuration.getDevice();
        if (device == null) {
            return NavigationEditorUtils.ZERO_SIZE;
        }
        State deviceState = this.configuration.getDeviceState();
        if (deviceState == null) {
            deviceState = device.getDefaultState();
        }
        return NavigationEditorUtils.notNull(device.getScreenSize(deviceState.getOrientation()));
    }

    Dimension getDeviceScreenSizeFor(Transform transform) {
        return transform.modelToView(this.getDeviceScreenSize());
    }
}

