/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.model;

import com.android.tools.idea.editors.navigation.annotations.Property;
import com.android.tools.idea.editors.navigation.model.Utilities;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ReflectiveHandler
extends DefaultHandler {
    public static final List<String> DEFAULT_PACKAGES = Collections.emptyList();
    public static final List<String> DEFAULT_CLASSES = Collections.emptyList();
    private final List<String> packagesImports = new ArrayList<String>(DEFAULT_PACKAGES);
    private final List<String> classImports = new ArrayList<String>(DEFAULT_CLASSES);
    private final MyErrorHandler errorHandler;
    private final Deque<ElementInfo> stack = new ArrayDeque<ElementInfo>();
    private final Map<String, Object> idToValue = new HashMap<String, Object>();
    private final Map<Class, Constructor> classToConstructor = new IdentityHashMap<Class, Constructor>();
    private final Map<Constructor, String[]> constructorToParameterNames = new IdentityHashMap<Constructor, String[]>();
    public Object result;

    public ReflectiveHandler(ErrorHandler errorHandler) {
        this.errorHandler = new MyErrorHandler(errorHandler);
    }

    @Override
    public void setDocumentLocator(Locator documentLocator) {
        this.errorHandler.documentLocator = documentLocator;
    }

    private void processNameSpace(String nameSpace) {
        String[] imports;
        for (String imp : imports = nameSpace.split("[?;]")) {
            String importPrefix = "import=";
            String packageSuffix = ".*";
            if (!imp.startsWith(importPrefix)) continue;
            if (imp.endsWith(packageSuffix)) {
                this.packagesImports.add(imp.substring(importPrefix.length(), imp.length() - packageSuffix.length()));
                continue;
            }
            this.classImports.add(imp.substring(importPrefix.length()));
        }
    }

    public Class getClassForName(String tag) throws ClassNotFoundException {
        String simpleName = StringUtil.capitalize((String)tag);
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (String clazz : this.classImports) {
            if (!clazz.endsWith("." + simpleName)) continue;
            return classLoader.loadClass(clazz);
        }
        for (String pkg : this.packagesImports) {
            try {
                return classLoader.loadClass(pkg + "." + simpleName);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException("Could not find class for tag: " + tag);
    }

    private static String getName(Annotation[] parameterAnnotation) {
        for (Annotation a : parameterAnnotation) {
            if (!(a instanceof Property)) continue;
            return ((Property)a).value();
        }
        return null;
    }

    private static Object valueFor(Class<?> type, String stringValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (type == String.class) {
            return stringValue;
        }
        if (type.isPrimitive()) {
            type = Utilities.wrapperForPrimitiveType(type);
        }
        return type.getConstructor(String.class).newInstance(stringValue);
    }

    private static String[] findParameterNames(Constructor constructor) {
        if (constructor == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Annotation[][] annotations = constructor.getParameterAnnotations();
        String[] result = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = ReflectiveHandler.getName(annotations[i]);
        }
        return result;
    }

    private static Constructor findConstructor(Class clz) {
        Constructor<?>[] constructors = clz.getConstructors();
        Arrays.sort(constructors, new Comparator<Constructor>(){

            @Override
            public int compare(Constructor c1, Constructor c2) {
                return c1.getParameterTypes().length - c2.getParameterTypes().length;
            }
        });
        for (Constructor<?> constructor : constructors) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            return constructor;
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        Constructor result = this.classToConstructor.get(clazz);
        if (result == null) {
            result = ReflectiveHandler.findConstructor(clazz);
            this.classToConstructor.put(clazz, result);
        }
        return result;
    }

    private String[] getParameterNames(Constructor constructor) {
        String[] result = this.constructorToParameterNames.get(constructor);
        if (result == null) {
            result = ReflectiveHandler.findParameterNames(constructor);
            this.constructorToParameterNames.put(constructor, result);
        }
        return result;
    }

    Object[] getParameterValues(Constructor constructor, Map<String, String> attributes, List<ElementInfo> elements) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, SAXException {
        String[] parameterNames = this.getParameterNames(constructor);
        Class<?>[] types = constructor.getParameterTypes();
        Object[] result = new Object[parameterNames.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            String stringValue = attributes.get(parameterName);
            if (stringValue != null) {
                result[i] = ReflectiveHandler.valueFor(types[i], stringValue);
                continue;
            }
            ElementInfo param = ReflectiveHandler.getParam(elements, parameterName, constructor);
            param.myValueAlreadySetInOuter = true;
            result[i] = param.getValue();
        }
        return result;
    }

    private static ElementInfo getParam(List<ElementInfo> elements, String parameterName, Object constructor) throws SAXException {
        for (ElementInfo element : elements) {
            if (!parameterName.equals(element.name)) continue;
            return element;
        }
        throw new SAXException("Unspecified parameter, " + parameterName + ", in " + constructor);
    }

    private static void applyMethod(Object target, String methodName, Object parameter) throws InvocationTargetException, IllegalAccessException {
        Class<?> targetType = target.getClass();
        Class<?> parameterType = parameter.getClass();
        for (Method m : targetType.getMethods()) {
            Class<?>[] parameterTypes;
            if (!m.getName().equals(methodName) || (parameterTypes = m.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(parameterType)) continue;
            m.invoke(target, parameter);
            break;
        }
    }

    private static Method getGetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        String getterMethodName = Utilities.getGetterMethodName(propertyName);
        return type.getMethod(getterMethodName, new Class[0]);
    }

    private static Method getSetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        String setterMethodName = Utilities.getSetterMethodName(propertyName);
        Class<?> propertyType = ReflectiveHandler.getGetter(type, propertyName).getReturnType();
        return type.getMethod(setterMethodName, propertyType);
    }

    private String[] getConstructorParameterNames(Class type) {
        if (type == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return this.getParameterNames(this.getConstructor(type));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        final ElementInfo elementInfo = new ElementInfo();
        elementInfo.name = qName;
        elementInfo.attributes = Utilities.toMap(attributes);
        String nameSpace = elementInfo.attributes.get("ns");
        if (nameSpace != null) {
            this.processNameSpace(nameSpace);
        }
        try {
            String idref = elementInfo.attributes.get("idref");
            if (idref != null) {
                if (!this.idToValue.containsKey(idref)) {
                    throw new SAXException("IDREF attribute, \"" + idref + "\" , was used before corresponding ID was defined.");
                }
                elementInfo.setValue(this.idToValue.get(idref));
            } else {
                elementInfo.type = this.getType(qName, elementInfo.attributes.get("class"));
                if (elementInfo.type != null) {
                    elementInfo.setEvaluator(new Evaluator(){

                        @Override
                        Object evaluate() throws SAXException {
                            try {
                                Constructor constructor = ReflectiveHandler.this.getConstructor(elementInfo.type);
                                if (constructor == null) {
                                    throw new SAXException("No Constructor found for " + elementInfo.name);
                                }
                                return constructor.newInstance(ReflectiveHandler.this.getParameterValues(constructor, elementInfo.attributes, elementInfo.elements));
                            }
                            catch (IllegalAccessException e) {
                                throw new SAXException(e);
                            }
                            catch (NoSuchMethodException e) {
                                throw new SAXException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new SAXException(e);
                            }
                            catch (InstantiationException e) {
                                throw new SAXException(e);
                            }
                        }
                    });
                } else {
                    if (this.stack.isEmpty()) {
                        throw new SAXException("Empty body at root");
                    }
                    final ElementInfo last = this.stack.peekFirst();
                    final Method getter = ReflectiveHandler.getGetter(last.type, qName);
                    elementInfo.myValueAlreadySetInOuter = true;
                    elementInfo.type = getter.getReturnType();
                    elementInfo.setEvaluator(new Evaluator(){

                        @Override
                        Object evaluate() throws SAXException {
                            try {
                                return getter.invoke(last.getValue(), new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                throw new SAXException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new SAXException(e);
                            }
                        }
                    });
                }
            }
            String id = elementInfo.attributes.get("id");
            if (id != null) {
                this.idToValue.put(id, elementInfo.getValue());
            }
            this.stack.addFirst(elementInfo);
        }
        catch (ClassNotFoundException e) {
            this.errorHandler.handleError(e);
        }
        catch (NoSuchMethodException e) {
            this.errorHandler.handleError(e);
        }
    }

    private Class getConstructorParameterType(Constructor constructor, String name) {
        if (constructor != null) {
            String[] parameterNames = this.getParameterNames(constructor);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            for (int i = 0; i < parameterNames.length; ++i) {
                if (!parameterNames[i].equals(name)) continue;
                return parameterTypes[i];
            }
        }
        return null;
    }

    private Class getType(String qName, String className) throws ClassNotFoundException {
        if (className != null) {
            return this.getClass().getClassLoader().loadClass(className);
        }
        try {
            return this.getClassForName(qName);
        }
        catch (ClassNotFoundException e) {
            if (this.stack.isEmpty()) {
                return null;
            }
            Class outerType = this.stack.peekFirst().type;
            try {
                return ReflectiveHandler.getSetter(outerType, qName).getParameterTypes()[0];
            }
            catch (NoSuchMethodException e1) {
                return this.getConstructorParameterType(this.getConstructor(outerType), qName);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElementInfo elementInfo = this.stack.removeFirst();
        this.result = elementInfo.getValue();
        elementInfo.installAttributes(this.errorHandler, this.getConstructorParameterNames(elementInfo.type));
        elementInfo.installSubElements(this.errorHandler);
        if (this.stack.size() != 0) {
            this.stack.peekFirst().elements.add(elementInfo);
        }
    }

    static class ElementInfo {
        public Class type;
        public String name;
        public boolean myValueAlreadySetInOuter = false;
        public Map<String, String> attributes;
        public List<ElementInfo> elements = new ArrayList<ElementInfo>();
        private LazyValue lazyValue = new LazyValue();

        ElementInfo() {
        }

        public Object getValue() throws SAXException {
            return this.lazyValue.getValue();
        }

        public void setValue(Object value) {
            this.lazyValue.setValue(value);
        }

        public void setEvaluator(Evaluator evaluator) {
            this.lazyValue.setEvaluator(evaluator);
        }

        private void installAttributes(MyErrorHandler errorHandler, String[] constructorParameterNames) throws SAXException {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                String attributeName = entry.getKey();
                if (Utilities.RESERVED_ATTRIBUTES.contains(attributeName) || ArrayUtil.contains((String)attributeName, (String[])constructorParameterNames) || "class".equals(attributeName)) continue;
                try {
                    Method setter = ReflectiveHandler.getSetter(this.type, attributeName);
                    Class argType = Utilities.wrapperForPrimitiveType(setter.getParameterTypes()[0]);
                    setter.invoke(this.getValue(), ReflectiveHandler.valueFor(argType, entry.getValue()));
                }
                catch (NoSuchMethodException e) {
                    errorHandler.handleWarning(e);
                }
                catch (IllegalAccessException e) {
                    errorHandler.handleWarning(e);
                }
                catch (InvocationTargetException e) {
                    errorHandler.handleWarning(e);
                }
                catch (InstantiationException e) {
                    errorHandler.handleWarning(e);
                }
            }
        }

        private void installSubElements(MyErrorHandler errorHandler) throws SAXException {
            for (ElementInfo element : this.elements) {
                if (element.myValueAlreadySetInOuter) continue;
                try {
                    Object outerValue = this.getValue();
                    if (Collection.class.isAssignableFrom(this.type)) {
                        ReflectiveHandler.applyMethod(outerValue, "add", element.getValue());
                        continue;
                    }
                    if (Map.class.isAssignableFrom(this.type)) continue;
                    ReflectiveHandler.getSetter(outerValue.getClass(), element.name).invoke(outerValue, element.getValue());
                }
                catch (NoSuchMethodException e) {
                    errorHandler.handleError(e);
                }
                catch (IllegalAccessException e) {
                    errorHandler.handleError(e);
                }
                catch (InvocationTargetException e) {
                    errorHandler.handleError(e);
                }
            }
        }
    }

    static class LazyValue {
        private static Object UNSET = new Object();
        private Evaluator evaluator;
        private Object value = UNSET;

        LazyValue() {
        }

        Object getValue() throws SAXException {
            if (this.value == UNSET) {
                this.value = this.evaluator.evaluate();
            }
            return this.value;
        }

        void setEvaluator(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        void setValue(Object value) {
            this.value = value;
        }
    }

    static abstract class Evaluator {
        Evaluator() {
        }

        abstract Object evaluate() throws SAXException;
    }

    static class MyErrorHandler {
        final ErrorHandler errorHandler;
        Locator documentLocator;

        MyErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        void handleWarning(Exception e) throws SAXException {
            this.errorHandler.warning(new SAXParseException(e.getMessage(), this.documentLocator, e));
        }

        void handleError(Exception e) throws SAXException {
            this.errorHandler.error(new SAXParseException(e.getMessage(), this.documentLocator, e));
        }
    }
}

