/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;

public class StringsVirtualFile
extends LightVirtualFile {
    public static final String NAME = "Translations Editor";
    private static final Key<StringsVirtualFile> KEY = Key.create((String)StringsVirtualFile.class.getName());
    private final AndroidFacet myFacet;

    private StringsVirtualFile(AndroidFacet facet) {
        super(NAME, (FileType)StringsResourceFileType.INSTANCE, (CharSequence)"");
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public VirtualFile getParent() {
        VirtualFile moduleFile = this.myFacet.getModule().getModuleFile();
        return moduleFile == null ? null : moduleFile.getParent();
    }

    public String getPath() {
        return AndroidFakeFileSystem.constructPathForFile(this.getName(), this.myFacet.getModule());
    }

    public static StringsVirtualFile getInstance(Project project, VirtualFile file) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        return module == null ? null : StringsVirtualFile.getStringsVirtualFile(module);
    }

    public static StringsVirtualFile getStringsVirtualFile(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        StringsVirtualFile vfile = (StringsVirtualFile)((Object)facet.getUserData(KEY));
        if (vfile == null) {
            vfile = new StringsVirtualFile(facet);
            facet.putUserData(KEY, (Object)vfile);
        }
        return vfile;
    }

    public VirtualFileSystem getFileSystem() {
        return AndroidFakeFileSystem.INSTANCE;
    }

    private static class StringsResourceFileType
    extends FakeFileType {
        public static final StringsResourceFileType INSTANCE = new StringsResourceFileType();

        private StringsResourceFileType() {
        }

        public boolean isMyFileType(VirtualFile file) {
            return file.getFileType() instanceof StringsResourceFileType;
        }

        public String getName() {
            return "";
        }

        public String getDescription() {
            return "";
        }

        public Icon getIcon() {
            return AndroidIcons.Globe;
        }
    }
}

