/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;

public class ColorUtils {
    private static final ImmutableSet<Pair<String, String>> CONTRAST_PAIRS = ImmutableSet.builder().add((Object)Pair.of((Object)"textColor", (Object)"colorBackground")).add((Object)Pair.of((Object)"textColor", (Object)"colorPrimary")).add((Object)Pair.of((Object)"textColorPrimary", (Object)"colorButtonNormal")).add((Object)Pair.of((Object)"textColorPrimary", (Object)"colorPrimary")).add((Object)Pair.of((Object)"textColorPrimary", (Object)"colorBackground")).build();
    public static final ImmutableSetMultimap<String, String> CONTRAST_MAP;
    private static final double THRESHOLD = 4.5;

    public static Set<String> getLowContrastColors(ThemeEditorContext context, EditedStyleItem item) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ResourceResolver styleResourceResolver = context.getConfiguration().getResourceResolver();
        ThemeEditorStyle currentTheme = context.getCurrentTheme();
        ImmutableSet contrastColorSet = CONTRAST_MAP.get((Object)item.getName());
        assert (styleResourceResolver != null && currentTheme != null);
        if (contrastColorSet == null) {
            return Collections.emptySet();
        }
        Color myItemColor = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, (ResourceValue)item.getSelectedValue(), context.getProject());
        if (myItemColor == null) {
            return Collections.emptySet();
        }
        for (String contrastColor : contrastColorSet) {
            ItemResourceValue contrastItem = ThemeEditorUtils.resolveItemFromParents(currentTheme, contrastColor, false);
            if (contrastItem == null) {
                contrastItem = ThemeEditorUtils.resolveItemFromParents(currentTheme, contrastColor, true);
            }
            if (contrastItem == null) continue;
            ResourceHelper.StateList stateList = ResourceHelper.resolveStateList((RenderResources)styleResourceResolver, (ResourceValue)contrastItem, context.getProject());
            if (stateList != null) {
                for (ResourceHelper.StateListState stateListState : stateList.getStates()) {
                    Color color = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, styleResourceResolver.findResValue(stateListState.getValue(), false), context.getProject());
                    if (color == null || !(ColorUtils.calculateContrastRatio(myItemColor, color) < 4.5)) continue;
                    StringBuilder stateNameBuilder = new StringBuilder();
                    if (!stateListState.getAttributes().isEmpty()) {
                        for (String attribute : stateListState.getAttributes().keySet()) {
                            if (!stateListState.getAttributes().get(attribute).booleanValue()) {
                                stateNameBuilder.append("not ");
                            }
                            stateNameBuilder.append(attribute.startsWith("state_") ? attribute.substring("state_".length()) : attribute);
                            stateNameBuilder.append(" <b>");
                            stateNameBuilder.append(contrastItem.getName());
                            stateNameBuilder.append("</b>");
                        }
                    } else {
                        stateNameBuilder.append("default <b>");
                        stateNameBuilder.append(contrastItem.getName());
                        stateNameBuilder.append("</b>");
                    }
                    builder.add((Object)stateNameBuilder.toString());
                }
                continue;
            }
            Color color = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, (ResourceValue)contrastItem, context.getProject());
            if (color == null || !(ColorUtils.calculateContrastRatio(myItemColor, color) < 4.5)) continue;
            builder.add((Object)("<b>" + contrastItem.getName() + "</b>"));
        }
        return builder.build();
    }

    public static double calculateContrastRatio(Color color1, Color color2) {
        double color1Luminance = ColorUtils.calculateColorLuminance(color1);
        double color2Luminance = ColorUtils.calculateColorLuminance(color2);
        return (Math.max(color1Luminance, color2Luminance) + 0.05) / (Math.min(color2Luminance, color1Luminance) + 0.05);
    }

    private static double calculateColorLuminance(Color color) {
        return ColorUtils.calculateLuminanceContribution((double)color.getRed() / 255.0) * 0.2126 + ColorUtils.calculateLuminanceContribution((double)color.getGreen() / 255.0) * 0.7152 + ColorUtils.calculateLuminanceContribution((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double calculateLuminanceContribution(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    static {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Pair pair : CONTRAST_PAIRS) {
            builder.put(pair.getFirst(), pair.getSecond());
            builder.put(pair.getSecond(), pair.getFirst());
        }
        CONTRAST_MAP = builder.build();
    }
}

