/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;

public class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    public static String getQualifiedStyleName(StyleResourceValue style) {
        return (style.isFramework() ? "@android:style/" : "@style/") + style.getName();
    }

    public static String getQualifiedItemName(ItemResourceValue item) {
        return (item.isFrameworkAttr() ? "android:" : "") + item.getName();
    }

    public static String getQualifiedValue(ItemResourceValue item) {
        ResourceUrl url = ResourceUrl.parse((String)item.getRawXmlValue(), (boolean)item.isFramework());
        return url == null ? item.getRawXmlValue() : url.toString();
    }

    private static StyleResourceValue getStyleResourceValue(ResourceResolver resolver, String qualifiedStyleName) {
        boolean isFrameworkStyle;
        String styleName;
        if (qualifiedStyleName.startsWith("@android:style/")) {
            styleName = qualifiedStyleName.substring("@android:style/".length());
            isFrameworkStyle = true;
        } else {
            styleName = qualifiedStyleName;
            if (styleName.startsWith("@style/")) {
                styleName = styleName.substring("@style/".length());
            }
            isFrameworkStyle = false;
        }
        return resolver.getStyle(styleName, isFrameworkStyle);
    }

    public static ThemeEditorStyle getStyle(Configuration configuration, ResourceResolver resolver, String qualifiedStyleName, Module module) {
        StyleResourceValue style = ResolutionUtils.getStyleResourceValue(resolver, qualifiedStyleName);
        return style == null ? null : new ThemeEditorStyle(configuration, style, module);
    }

    public static ThemeEditorStyle getStyle(Configuration configuration, String qualifiedStyleName, Module module) {
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        return ResolutionUtils.getStyle(configuration, configuration.getResourceResolver(), qualifiedStyleName, module);
    }

    public static AttributeDefinition getAttributeDefinition(Configuration configuration, ItemResourceValue itemResValue) {
        AttributeDefinitions definitions;
        Module module = configuration.getModule();
        if (itemResValue.isFrameworkAttr()) {
            IAndroidTarget target = configuration.getTarget();
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module.getProject());
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = facet.getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(itemResValue.getName());
    }

    public static int getOriginalApiLevel(String name, Project project) {
        boolean isAttribute;
        if (name == null) {
            return -1;
        }
        if (name.startsWith("android:")) {
            isAttribute = true;
        } else if (name.startsWith("@android:")) {
            isAttribute = false;
        } else {
            return -1;
        }
        ApiLookup apiLookup = IntellijLintClient.getApiLookup(project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        if (isAttribute) {
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        String[] namePieces = name.substring("@android:".length()).split("/");
        if (namePieces.length == 2) {
            return apiLookup.getFieldVersion("android/R$" + namePieces[0], AndroidResourceUtil.getFieldNameByResourceName(namePieces[1]));
        }
        return -1;
    }
}

