/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.configurations.OrientationMenuAction;
import com.android.tools.idea.configurations.TargetMenuAction;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.editors.theme.AttributesPanel;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorTable;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.ThemesListModel;
import com.android.tools.idea.editors.theme.attributes.AttributesGrouper;
import com.android.tools.idea.editors.theme.attributes.AttributesModelColorPaletteModel;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListPaletteCellRenderer;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.ResourceNotificationManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PanelUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.android.dom.drawable.DrawableDomElement;
import org.jetbrains.android.facet.AndroidFacet;

public class ThemeEditorComponent
extends Splitter {
    private static final Logger LOG = Logger.getInstance(ThemeEditorComponent.class);
    private static final JBColor PREVIEW_BACKGROUND = new JBColor(new Color(0xFFFFFF), new Color(3422009));
    private static final DefaultTableModel EMPTY_TABLE_MODEL = new DefaultTableModel();
    private static final ImmutableMap<String, Integer> SORTING_MAP = ImmutableMap.builder().put((Object)"colorPrimary", (Object)1).put((Object)"colorPrimaryDark", (Object)2).put((Object)"colorAccent", (Object)3).build();
    public static final Comparator SIMPLE_MODE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ThemeEditorStyle) {
                return -1;
            }
            if (o2 instanceof ThemeEditorStyle) {
                return 1;
            }
            if (o1 instanceof EditedStyleItem && o2 instanceof EditedStyleItem) {
                Integer pos1 = (Integer)SORTING_MAP.get((Object)((EditedStyleItem)o1).getName());
                Integer pos2 = (Integer)SORTING_MAP.get((Object)((EditedStyleItem)o2).getName());
                if (pos1 != null && pos2 != null) {
                    return pos1 - pos2;
                }
                if (pos1 != null) {
                    return -1;
                }
                if (pos2 != null) {
                    return 1;
                }
                return ((EditedStyleItem)o1).compareTo((EditedStyleItem)o2);
            }
            return Ordering.usingToString().compare(o1, o2);
        }
    };
    public static final int REGULAR_CELL_PADDING = 4;
    public static final int LARGE_CELL_PADDING = 10;
    private final Project myProject;
    private EditedStyleItem mySubStyleSourceAttribute;
    private String myThemeName;
    private String mySubStyleName;
    private final ThemeEditorContext myThemeEditorContext;
    private final AndroidThemePreviewPanel myPreviewPanel;
    private final StyleAttributesFilter myAttributesFilter;
    private TableRowSorter<AttributesTableModel> myAttributesSorter;
    private final SimpleModeFilter mySimpleModeFilter;
    private final AttributesPanel myPanel;
    private final ThemeEditorTable myAttributesTable;
    private final ResourceNotificationManager.ResourceChangeListener myResourceChangeListener;
    private boolean myIsSubscribedResourceNotification;
    private MutableCollectionComboBoxModel<Module> myModuleComboModel;
    private ScheduledFuture<?> myScheduledSearch;
    private String myHoverPreviewTheme;
    private AttributesTableModel myModel;

    public ThemeEditorComponent(Project project) {
        this.myProject = project;
        this.myPanel = new AttributesPanel();
        this.initializeModulesCombo(null);
        JComboBox moduleCombo = this.myPanel.getModuleCombo();
        moduleCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorComponent.this.reload(ThemeEditorComponent.this.myThemeName, ThemeEditorComponent.this.mySubStyleName, ThemeEditorComponent.this.getSelectedModule().getName());
            }
        });
        moduleCombo.setRenderer(new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getName());
            }
        });
        Module selectedModule = (Module)this.myModuleComboModel.getSelected();
        assert (selectedModule != null);
        Configuration configuration = ThemeEditorUtils.getConfigurationForModule(selectedModule);
        this.myThemeEditorContext = new ThemeEditorContext(configuration);
        this.myThemeEditorContext.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((flags & 0xF6) != 0) {
                    ThemeEditorComponent.this.loadStyleAttributes();
                    ThemeEditorComponent.this.myThemeEditorContext.getConfiguration().save();
                }
                return true;
            }
        });
        this.myPreviewPanel = new AndroidThemePreviewPanel(this.myThemeEditorContext, (Color)PREVIEW_BACKGROUND);
        this.myPreviewPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        GoToListener goToListener = new GoToListener(){

            @Override
            public void goTo(EditedStyleItem value) {
                ResourceResolver resolver = ThemeEditorComponent.this.myThemeEditorContext.getResourceResolver();
                if (value.isAttr() && ThemeEditorComponent.this.getUsedStyle() != null && resolver != null) {
                    ItemResourceValue resourceValue = (ItemResourceValue)resolver.findResValue(value.getValue(), false);
                    if (resourceValue == null) {
                        LOG.error("Unable to resolve " + value.getValue());
                        return;
                    }
                    ThemeEditorComponent.this.mySubStyleName = ResolutionUtils.getQualifiedValue(resourceValue);
                } else {
                    ThemeEditorComponent.this.mySubStyleName = value.getValue();
                }
                ThemeEditorComponent.this.mySubStyleSourceAttribute = value;
                ThemeEditorComponent.this.loadStyleAttributes();
            }

            @Override
            public void goToParent() {
                ThemeEditorComponent.this.goToParent();
            }
        };
        this.myAttributesTable = this.myPanel.getAttributesTable();
        this.myAttributesTable.customizeTable(this.myThemeEditorContext, this.myPreviewPanel);
        this.myAttributesTable.setGoToListener(goToListener);
        this.updateUiParameters();
        this.myAttributesFilter = new StyleAttributesFilter();
        this.mySimpleModeFilter = new SimpleModeFilter();
        this.myPanel.getBackButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorComponent.this.mySubStyleName = null;
                ThemeEditorComponent.this.loadStyleAttributes();
            }
        });
        this.myPanel.getAdvancedFilterCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ThemeEditorComponent.this.myAttributesTable.isEditing()) {
                    ThemeEditorComponent.this.myAttributesTable.getCellEditor().cancelCellEditing();
                }
                ThemeEditorComponent.this.myAttributesTable.clearSelection();
                ThemeEditorComponent.this.myPanel.getPalette().clearSelection();
                ThemeEditorComponent.this.configureFilter();
                ((TableRowSorter)ThemeEditorComponent.this.myAttributesTable.getRowSorter()).sort();
                ThemeEditorComponent.this.myAttributesTable.updateRowHeights();
            }
        });
        this.myPanel.getThemeCombo().setRenderer(new StyleListPaletteCellRenderer(this.myThemeEditorContext, new StyleListPaletteCellRenderer.ItemHoverListener(){

            @Override
            public void itemHovered(String name) {
                if (!name.equals(ThemeEditorComponent.this.myHoverPreviewTheme)) {
                    ThemeEditorComponent.this.mySubStyleName = null;
                    ThemeEditorComponent.this.mySubStyleSourceAttribute = null;
                    ThemeEditorComponent.this.refreshPreviewPanel(name);
                }
            }
        }, this.myPanel.getThemeCombo()));
        this.myPanel.getThemeCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedItem = (String)ThemeEditorComponent.this.myPanel.getThemeCombo().getSelectedItem();
                if (!ThemesListModel.isSpecialOption(selectedItem)) {
                    ThemeEditorComponent.this.myThemeName = selectedItem;
                    ThemeEditorComponent.this.myHoverPreviewTheme = null;
                    ThemeEditorComponent.this.mySubStyleName = null;
                    ThemeEditorComponent.this.mySubStyleSourceAttribute = null;
                    ThemeEditorComponent.this.loadStyleAttributes();
                } else {
                    ThemeEditorComponent.this.myPanel.setSelectedTheme(ThemeEditorComponent.this.myThemeName);
                    if ("Create New Theme".equals(selectedItem)) {
                        ThemeEditorComponent.this.createNewTheme();
                    } else if ("Show all themes".equals(selectedItem)) {
                        ThemeEditorComponent.this.selectNewTheme();
                    } else {
                        ThemeEditorComponent.this.renameTheme();
                    }
                }
            }
        });
        this.myPanel.getThemeCombo().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ThemeEditorComponent.this.myHoverPreviewTheme = null;
                ThemeEditorComponent.this.mySubStyleName = null;
                ThemeEditorComponent.this.mySubStyleSourceAttribute = null;
                ThemeEditorComponent.this.loadStyleAttributes();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.myPanel.getAttrGroupCombo().setModel(new DefaultComboBoxModel<AttributesGrouper.GroupBy>(AttributesGrouper.GroupBy.values()));
        this.myPanel.getAttrGroupCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorComponent.this.loadStyleAttributes();
            }
        });
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new OrientationMenuAction(this.myPreviewPanel, false));
        group.add((AnAction)new DeviceMenuAction(this.myPreviewPanel, false));
        group.add((AnAction)new TargetMenuAction(this.myPreviewPanel, true, false));
        group.add((AnAction)new LocaleMenuAction(this.myPreviewPanel, false));
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("ThemeToolbar", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(1);
        JPanel toolbar = new JPanel(null);
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        toolbar.setBorder(BorderFactory.createMatteBorder(7, 14, 7, 14, (Color)PREVIEW_BACKGROUND));
        toolbar.setBackground((Color)PREVIEW_BACKGROUND);
        final JComponent actionToolbarComponent = actionToolbar.getComponent();
        actionToolbarComponent.setBackground((Color)PREVIEW_BACKGROUND);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component component : actionToolbarComponent.getComponents()) {
                    component.setBackground((Color)PREVIEW_BACKGROUND);
                }
            }
        });
        toolbar.add(actionToolbarComponent);
        final SearchTextField textField = new SearchTextField(true);
        textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, textField.getPreferredSize().height));
        textField.setBackground((Color)PREVIEW_BACKGROUND);
        for (Component component : textField.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            component.setBackground((Color)PREVIEW_BACKGROUND);
        }
        final ScheduledExecutorService searchUpdateScheduler = Executors.newSingleThreadScheduledExecutor();
        textField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (ThemeEditorComponent.this.myScheduledSearch != null) {
                    ThemeEditorComponent.this.myScheduledSearch.cancel(false);
                }
                ThemeEditorComponent.this.myScheduledSearch = searchUpdateScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ThemeEditorComponent.this.myPreviewPanel.setSearchTerm(textField.getText());
                    }
                }, 300L, TimeUnit.MILLISECONDS);
            }
        });
        toolbar.add((Component)textField);
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add((Component)this.myPreviewPanel, "Center");
        previewPanel.add((Component)toolbar, "North");
        this.setFirstComponent(previewPanel);
        this.setSecondComponent(this.myPanel.getRightPanel());
        this.setShowDividerControls(false);
        this.myResourceChangeListener = new ResourceNotificationManager.ResourceChangeListener(){

            @Override
            public void resourcesChanged(Set<ResourceNotificationManager.Reason> reason) {
                ThemeEditorComponent.this.myThemeEditorContext.updateThemeResolver();
                ThemeEditorComponent.this.reload(ThemeEditorComponent.this.myThemeName, ThemeEditorComponent.this.mySubStyleName);
            }
        };
        this.reload(null);
    }

    public Module getSelectedModule() {
        Module module = (Module)this.myModuleComboModel.getSelected();
        assert (module != null);
        return module;
    }

    private void initializeModulesCombo(String defaultModuleName) {
        ImmutableList<Module> modules = ThemeEditorUtils.findAndroidModules(this.myProject);
        assert (modules.size() > 0) : "Theme Editor shouldn't be launched in a project with no Android modules";
        Module defaultModule = null;
        for (Module module : modules) {
            if (!module.getName().equals(defaultModuleName)) continue;
            defaultModule = module;
            break;
        }
        this.myModuleComboModel = defaultModule == null ? new MutableCollectionComboBoxModel(modules) : new MutableCollectionComboBoxModel(modules, defaultModule);
        JComboBox moduleCombo = this.myPanel.getModuleCombo();
        moduleCombo.setModel(this.myModuleComboModel);
    }

    private void subscribeResourceNotification() {
        if (this.myIsSubscribedResourceNotification) {
            return;
        }
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myThemeEditorContext.getProject());
        AndroidFacet facet = AndroidFacet.getInstance(this.myThemeEditorContext.getCurrentContextModule());
        assert (facet != null) : this.myThemeEditorContext.getCurrentContextModule().getName() + " module doesn't have an AndroidFacet";
        manager.addListener(this.myResourceChangeListener, facet, null, null);
        this.myIsSubscribedResourceNotification = true;
    }

    private void unsubscribeResourceNotification() {
        if (this.myIsSubscribedResourceNotification) {
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myThemeEditorContext.getProject());
            AndroidFacet facet = AndroidFacet.getInstance(this.myThemeEditorContext.getCurrentContextModule());
            assert (facet != null) : this.myThemeEditorContext.getCurrentContextModule().getName() + " module doesn't have an AndroidFacet";
            manager.removeListener(this.myResourceChangeListener, facet, null, null);
            this.myIsSubscribedResourceNotification = false;
        }
    }

    public void selectNotify() {
        this.reload(this.myThemeName, this.mySubStyleName);
        this.subscribeResourceNotification();
    }

    public void deselectNotify() {
        this.unsubscribeResourceNotification();
    }

    private void configureFilter() {
        if (this.myPanel.isAdvancedMode()) {
            this.myAttributesFilter.setFilterEnabled(false);
            this.myAttributesSorter.setRowFilter(this.myAttributesFilter);
            this.myAttributesSorter.setSortKeys(null);
        } else {
            this.mySimpleModeFilter.configure((Set<String>)this.myModel.getDefinedAttributes(), ThemeEditorUtils.isSelectedAppCompatTheme(this.myThemeEditorContext));
            this.myAttributesSorter.setRowFilter(this.mySimpleModeFilter);
            this.myAttributesSorter.setSortKeys((List<RowSorter.SortKey>)ImmutableList.of((Object)new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        }
    }

    private boolean createNewTheme() {
        String newThemeName = ThemeEditorUtils.showCreateNewStyleDialog(this.getSelectedTheme(), this.myThemeEditorContext, !this.isSubStyleSelected(), null);
        if (newThemeName != null) {
            this.myThemeName = newThemeName;
            this.mySubStyleName = null;
            return true;
        }
        return false;
    }

    private boolean selectNewTheme() {
        String newThemeName;
        ThemeSelectionDialog dialog = new ThemeSelectionDialog(this.myThemeEditorContext.getConfiguration());
        if (dialog.showAndGet() && (newThemeName = dialog.getTheme()) != null) {
            this.reload(newThemeName);
            return true;
        }
        return false;
    }

    private boolean renameTheme() {
        ThemeEditorStyle selectedTheme = this.getSelectedTheme();
        assert (selectedTheme != null);
        assert (selectedTheme.isProjectStyle());
        PsiElement namePsiElement = selectedTheme.getNamePsiElement();
        if (namePsiElement == null) {
            return false;
        }
        RenameDialog renameDialog = new RenameDialog(this.myThemeEditorContext.getProject(), namePsiElement, null, null);
        renameDialog.show();
        if (renameDialog.isOK()) {
            String newName = renameDialog.getNewName();
            this.myThemeName = selectedTheme.getQualifiedName().replace(selectedTheme.getName(), newName);
            this.mySubStyleName = null;
            return true;
        }
        return false;
    }

    public void goToParent() {
        ThemeEditorStyle selectedStyle = this.getUsedStyle();
        if (selectedStyle == null) {
            LOG.error("No style selected.");
            return;
        }
        ThemeEditorStyle parent = this.getUsedStyle().getParent(this.myThemeEditorContext.getThemeResolver());
        assert (parent != null);
        if (this.isSubStyleSelected()) {
            this.mySubStyleName = parent.getQualifiedName();
            this.loadStyleAttributes();
        } else {
            this.myPanel.setSelectedTheme(parent.getQualifiedName());
        }
    }

    ThemeEditorStyle getHoveredTheme() {
        if (this.myHoverPreviewTheme != null) {
            return this.myThemeEditorContext.getThemeResolver().getTheme(this.myHoverPreviewTheme);
        }
        return null;
    }

    ThemeEditorStyle getSelectedTheme() {
        if (this.myThemeName != null) {
            return this.myThemeEditorContext.getThemeResolver().getTheme(this.myThemeName);
        }
        return null;
    }

    private ThemeEditorStyle getUsedStyle() {
        if (this.mySubStyleName != null) {
            return this.getCurrentSubStyle();
        }
        return this.getSelectedTheme();
    }

    ThemeEditorStyle getCurrentSubStyle() {
        if (this.mySubStyleName == null) {
            return null;
        }
        return this.myThemeEditorContext.getThemeResolver().getTheme(this.mySubStyleName);
    }

    private boolean isSubStyleSelected() {
        return this.mySubStyleName != null;
    }

    private AttributesGrouper.GroupBy getSelectedAttrGroup() {
        return (AttributesGrouper.GroupBy)((Object)this.myPanel.getAttrGroupCombo().getSelectedItem());
    }

    private void createNewThemeWithAttributeValue(final EditedStyleItem rv, final String strValue) {
        String sourcePropertyName;
        if (strValue.equals(rv.getValue())) {
            return;
        }
        ThemeEditorStyle selectedStyle = this.getUsedStyle();
        if (selectedStyle == null) {
            LOG.error("No style/theme selected.");
            return;
        }
        String message = String.format("<html>The %1$s '<code>%2$s</code>' is Read-Only.<br/>A new %1$s will be created to modify '<code>%3$s</code>'.<br/></html>", this.isSubStyleSelected() ? "style" : "theme", selectedStyle.getQualifiedName(), rv.getName());
        final String newStyleName = ThemeEditorUtils.showCreateNewStyleDialog(selectedStyle, this.myThemeEditorContext, !this.isSubStyleSelected(), message);
        if (newStyleName == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ThemeEditorComponent.this.myThemeEditorContext.updateThemeResolver();
                ThemeEditorStyle newStyle = ThemeEditorComponent.this.myThemeEditorContext.getThemeResolver().getTheme(newStyleName);
                assert (newStyle != null);
                newStyle.setValue(rv.getQualifiedName(), strValue);
            }
        });
        if (!this.isSubStyleSelected()) {
            this.myThemeName = newStyleName;
            this.mySubStyleName = null;
            return;
        }
        ThemeEditorStyle selectedTheme = this.getSelectedTheme();
        if (selectedTheme == null) {
            LOG.error("No theme selected.");
            return;
        }
        String string = sourcePropertyName = this.mySubStyleSourceAttribute.isAttr() ? this.mySubStyleSourceAttribute.getAttrPropertyName() : this.mySubStyleSourceAttribute.getQualifiedName();
        if (selectedTheme.isReadOnly()) {
            message = String.format("<html>The style '%1$s' which references to '%2$s' is also Read-Only.<br/>A new theme will be created to point to the modified style '%3$s'.<br/></html>", selectedTheme.getQualifiedName(), rv.getName(), newStyleName);
            final String newThemeName = ThemeEditorUtils.showCreateNewStyleDialog(selectedTheme, this.myThemeEditorContext, true, message);
            if (newThemeName != null) {
                this.myThemeName = newThemeName;
                this.mySubStyleName = newStyleName;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThemeEditorComponent.this.myThemeEditorContext.updateThemeResolver();
                        ThemeEditorStyle newTheme = ThemeEditorComponent.this.myThemeEditorContext.getThemeResolver().getTheme(newThemeName);
                        assert (newTheme != null);
                        newTheme.setValue(sourcePropertyName, newStyleName);
                    }
                });
            }
        } else {
            FolderConfiguration configurationToModify = selectedTheme.findBestConfiguration(this.myThemeEditorContext.getConfiguration().getFullConfig());
            selectedTheme.setValue(configurationToModify, sourcePropertyName, newStyleName);
            this.mySubStyleName = newStyleName;
        }
    }

    public void reload(String defaultThemeName) {
        this.reload(defaultThemeName, null);
    }

    public void reload(String defaultThemeName, String defaultSubStyleName) {
        this.reload(defaultThemeName, defaultSubStyleName, this.getSelectedModule().getName());
    }

    public void reload(String defaultThemeName, String defaultSubStyleName, String defaultModuleName) {
        this.myHoverPreviewTheme = null;
        this.unsubscribeResourceNotification();
        this.initializeModulesCombo(defaultModuleName);
        this.myThemeEditorContext.setCurrentContextModule(this.getSelectedModule());
        this.subscribeResourceNotification();
        this.mySubStyleSourceAttribute = null;
        ThemeResolver themeResolver = this.myThemeEditorContext.getThemeResolver();
        this.myPanel.getThemeCombo().setModel(new ThemesListModel(this.myThemeEditorContext, (List<String>)ThemeEditorUtils.getDefaultThemeNames(themeResolver), defaultThemeName));
        this.myThemeName = (String)this.myPanel.getThemeCombo().getSelectedItem();
        this.mySubStyleName = StringUtil.equals((CharSequence)this.myThemeName, (CharSequence)defaultThemeName) ? defaultSubStyleName : null;
        this.loadStyleAttributes();
    }

    private void loadStyleAttributes() {
        ThemeEditorStyle selectedTheme = this.getHoveredTheme();
        ThemeEditorStyle selectedStyle = null;
        if (selectedTheme == null) {
            selectedTheme = this.getSelectedTheme();
            selectedStyle = this.getCurrentSubStyle();
        }
        this.myAttributesTable.setRowSorter(null);
        if (selectedTheme == null) {
            this.myPreviewPanel.setError(this.myThemeName);
            this.myAttributesTable.setModel(EMPTY_TABLE_MODEL);
            return;
        }
        this.myPreviewPanel.setError(null);
        this.myThemeEditorContext.setCurrentTheme(selectedTheme);
        this.myPanel.setSubstyleName(this.mySubStyleName);
        this.myPanel.getBackButton().setVisible(this.mySubStyleName != null);
        Configuration configuration = this.myThemeEditorContext.getConfiguration();
        configuration.setTheme(selectedTheme.getQualifiedName());
        assert (configuration.getResourceResolver() != null);
        this.myModel = new AttributesTableModel(configuration, selectedStyle != null ? selectedStyle : selectedTheme, this.getSelectedAttrGroup(), this.myThemeEditorContext);
        this.myModel.addThemePropertyChangedListener(new AttributesTableModel.ThemePropertyChangedListener(){

            @Override
            public void attributeChangedOnReadOnlyTheme(EditedStyleItem attribute, String newValue) {
                ThemeEditorComponent.this.createNewThemeWithAttributeValue(attribute, newValue);
            }
        });
        this.myAttributesSorter = new TableRowSorter<AttributesTableModel>(this.myModel);
        this.myAttributesSorter.setComparator(0, SIMPLE_MODE_COMPARATOR);
        this.configureFilter();
        this.myAttributesTable.removeEditor();
        this.myAttributesTable.setModel(this.myModel);
        this.myAttributesTable.setRowSorter(this.myAttributesSorter);
        this.myAttributesTable.updateRowHeights();
        this.myPanel.getPalette().setModel(new AttributesModelColorPaletteModel(configuration, this.myModel));
        this.myPanel.getPalette().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AttributesModelColorPaletteModel model = (AttributesModelColorPaletteModel)ThemeEditorComponent.this.myPanel.getPalette().getModel();
                    List<EditedStyleItem> references = model.getReferences((Color)e.getItem());
                    if (references.isEmpty()) {
                        return;
                    }
                    HashSet<String> attributeNames = new HashSet<String>(references.size());
                    for (EditedStyleItem item : references) {
                        attributeNames.add(item.getQualifiedName());
                    }
                    ThemeEditorComponent.this.myAttributesFilter.setAttributesFilter(attributeNames);
                    ThemeEditorComponent.this.myAttributesFilter.setFilterEnabled(true);
                } else {
                    ThemeEditorComponent.this.myAttributesFilter.setFilterEnabled(false);
                }
                if (ThemeEditorComponent.this.myAttributesTable.isEditing()) {
                    ThemeEditorComponent.this.myAttributesTable.getCellEditor().cancelCellEditing();
                }
                ((TableRowSorter)ThemeEditorComponent.this.myAttributesTable.getRowSorter()).sort();
                ThemeEditorComponent.this.myPanel.getAdvancedFilterCheckBox().getModel().setSelected(!((ThemeEditorComponent)ThemeEditorComponent.this).myAttributesFilter.myIsFilterEnabled);
            }
        });
        this.myAttributesTable.updateRowHeights();
        this.myPreviewPanel.invalidateGraphicsRenderer();
        this.myPreviewPanel.revalidate();
        this.myAttributesTable.repaint();
        this.myPanel.getThemeCombo().repaint();
    }

    private void refreshPreviewPanel(String hoveredPreviewTheme) {
        this.myHoverPreviewTheme = hoveredPreviewTheme;
        ThemeEditorStyle hoveredTheme = this.myThemeEditorContext.getThemeResolver().getTheme(this.myHoverPreviewTheme);
        assert (hoveredTheme != null);
        this.myThemeEditorContext.setCurrentTheme(hoveredTheme);
        Configuration configuration = this.myThemeEditorContext.getConfiguration();
        configuration.setTheme(hoveredTheme.getQualifiedName());
        this.myPreviewPanel.invalidateGraphicsRenderer();
        this.myPreviewPanel.revalidate();
    }

    public void dispose() {
        this.myAttributesTable.removeEditor();
        this.myPreviewPanel.dispose();
        this.myThemeEditorContext.dispose();
        super.dispose();
    }

    public void setUI(PanelUI ui) {
        super.setUI(ui);
        this.updateUiParameters();
    }

    private void updateUiParameters() {
        Font regularFont = UIUtil.getLabelFont();
        int regularFontSize = this.getFontMetrics(regularFont).getHeight();
        Font headerFont = regularFont.deriveFont((float)regularFontSize * 1.3f);
        if (this.myAttributesTable == null) {
            return;
        }
        int headerFontSize = this.getFontMetrics(headerFont).getHeight();
        ResourceComponent sampleComponent = new ResourceComponent();
        int bigCellSize = sampleComponent.getPreferredSize().height;
        this.myAttributesTable.setClassHeights((Map<Class<?>, Integer>)ImmutableMap.of(Object.class, (Object)(regularFontSize + 4), Color.class, (Object)bigCellSize, DrawableDomElement.class, (Object)bigCellSize, TableLabel.class, (Object)(headerFontSize + 10), AttributesTableModel.ParentAttribute.class, (Object)bigCellSize));
    }

    class StyleAttributesFilter
    extends AttributesFilter {
        public StyleAttributesFilter() {
            this.myIsFilterEnabled = true;
            this.filterAttributes = Collections.emptySet();
        }

        public void setFilterEnabled(boolean enabled) {
            this.myIsFilterEnabled = enabled;
        }

        public void setAttributesFilter(Set<String> attributeNames) {
            this.filterAttributes = ImmutableSet.copyOf(attributeNames);
        }
    }

    abstract class AttributesFilter
    extends RowFilter<AttributesTableModel, Integer> {
        boolean myIsFilterEnabled;
        Set<String> filterAttributes;

        AttributesFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends AttributesTableModel, ? extends Integer> entry) {
            if (!this.myIsFilterEnabled) {
                return true;
            }
            int row = entry.getIdentifier();
            if (entry.getModel().isThemeParentRow(row)) {
                return true;
            }
            Object value = entry.getModel().getValueAt(row, 1);
            if (value instanceof TableLabel) {
                return false;
            }
            String attributeName = value instanceof EditedStyleItem ? ((EditedStyleItem)value).getQualifiedName() : value.toString();
            ThemeEditorStyle selectedTheme = ThemeEditorComponent.this.getUsedStyle();
            if (selectedTheme == null) {
                LOG.error("No theme selected.");
                return false;
            }
            return this.filterAttributes.contains(attributeName);
        }
    }

    class SimpleModeFilter
    extends AttributesFilter {
        public final Set<String> ATTRIBUTES_DEFAULT_FILTER = ImmutableSet.of((Object)"colorPrimary", (Object)"colorPrimaryDark", (Object)"colorAccent", (Object)"colorForeground", (Object)"textColorPrimary", (Object)"textColorSecondary", (Object[])new String[]{"textColorPrimaryInverse", "textColorSecondaryInverse", "colorBackground", "windowBackground", "navigationBarColor", "statusBarColor"});

        public SimpleModeFilter() {
            this.myIsFilterEnabled = true;
            this.filterAttributes = new HashSet();
        }

        public void configure(Set<String> availableAttributes, boolean appCompat) {
            this.filterAttributes.clear();
            for (String candidate : this.ATTRIBUTES_DEFAULT_FILTER) {
                if (appCompat && availableAttributes.contains(candidate)) {
                    this.filterAttributes.add(candidate);
                    continue;
                }
                this.filterAttributes.add("android:" + candidate);
            }
        }
    }

    public static interface GoToListener {
        public void goTo(EditedStyleItem var1);

        public void goToParent();
    }
}

