/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;

public class ThemeEditorContext {
    private Configuration myConfiguration;
    private ThemeEditorStyle myCurrentTheme;
    private ThemeResolver myThemeResolver;
    private final List<ChangeListener> myChangeListeners = new ArrayList<ChangeListener>();
    private final List<ConfigurationListener> myConfigurationListeners = new ArrayList<ConfigurationListener>();
    private boolean myEnabledListeners = true;
    private final ConfigurationListener myConfigurationListener = new ConfigurationListener(){

        @Override
        public boolean changed(int flags) {
            if (!ThemeEditorContext.this.myEnabledListeners) {
                return true;
            }
            boolean accepted = true;
            for (ConfigurationListener listener : ThemeEditorContext.this.myConfigurationListeners) {
                accepted &= listener.changed(flags);
            }
            return accepted;
        }
    };

    public ThemeEditorContext(Configuration configuration) {
        this.setConfiguration(configuration);
        this.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((0xF6 & flags) != 0) {
                    ThemeEditorContext.this.updateThemeResolver();
                }
                return true;
            }
        });
    }

    public void updateThemeResolver() {
        this.myEnabledListeners = false;
        this.myConfiguration.setTheme(null);
        this.myEnabledListeners = true;
        this.myThemeResolver = new ThemeResolver(this.myConfiguration);
    }

    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    public Module getCurrentContextModule() {
        return this.myConfiguration.getModule();
    }

    public void setCurrentTheme(ThemeEditorStyle currentTheme) {
        this.myCurrentTheme = currentTheme;
    }

    public ThemeEditorStyle getCurrentTheme() {
        return this.myCurrentTheme;
    }

    public Module getModuleForResources() {
        if (this.myCurrentTheme != null && this.myCurrentTheme.getSourceModule() != null) {
            return this.myCurrentTheme.getSourceModule();
        }
        return this.myConfiguration.getModule();
    }

    public void setCurrentContextModule(Module module) {
        this.setConfiguration(ThemeEditorUtils.getConfigurationForModule(module));
    }

    public ResourceResolver getResourceResolver() {
        return this.myConfiguration.getResourceResolver();
    }

    public Project getProject() {
        return this.myConfiguration.getModule().getProject();
    }

    public void addConfigurationListener(ConfigurationListener configurationListener) {
        this.myConfigurationListeners.add(configurationListener);
    }

    public ThemeResolver getThemeResolver() {
        return this.myThemeResolver;
    }

    public void setConfiguration(Configuration configuration) {
        if (this.myConfiguration != null) {
            this.myConfiguration.removeListener(this.myConfigurationListener);
        }
        this.myConfiguration = configuration;
        this.updateThemeResolver();
        this.myConfiguration.addListener(this.myConfigurationListener);
        this.fireNewConfiguration();
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeListeners.add(listener);
    }

    private void fireNewConfiguration() {
        for (ChangeListener listener : this.myChangeListeners) {
            listener.onNewConfiguration(this);
        }
    }

    public void dispose() {
        this.myConfiguration.removeListener(this.myConfigurationListener);
        this.myConfigurationListeners.clear();
    }

    public static interface ChangeListener {
        public void onNewConfiguration(ThemeEditorContext var1);
    }
}

