/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.editors.theme.ThemeEditorProvider;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;

public class ThemeEditorNotificationProvider
extends EditorNotifications.Provider<InfoPanel> {
    private static final Key<InfoPanel> KEY = Key.create((String)"android.editors.theme");
    private final Project myProject;
    private boolean myDismissed = false;

    public ThemeEditorNotificationProvider(Project project) {
        this.myProject = project;
    }

    public Key<InfoPanel> getKey() {
        return KEY;
    }

    public InfoPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        if (this.myDismissed) {
            return null;
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.myProject, file);
        if (!ThemeEditorProvider.isAndroidTheme(psiFile)) {
            return null;
        }
        final InfoPanel panel = new InfoPanel();
        panel.setText("Edit all themes in the project in the theme editor.");
        panel.createActionLabel("Open editor", new Runnable(){

            @Override
            public void run() {
                ThemeEditorUtils.openThemeEditor(ThemeEditorNotificationProvider.this.myProject);
            }
        });
        panel.createActionLabel("Hide notification", new Runnable(){

            @Override
            public void run() {
                panel.setVisible(false);
                ThemeEditorNotificationProvider.this.myDismissed = true;
            }
        });
        return panel;
    }

    public static class InfoPanel
    extends EditorNotificationPanel {
        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            return color == null ? UIUtil.getPanelBackground() : color;
        }
    }
}

