/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;

public class ThemeResolver {
    private final Map<String, ThemeEditorStyle> myThemeByName = Maps.newHashMap();
    private final ImmutableList<ThemeEditorStyle> myFrameworkThemes;
    private final ImmutableList<ThemeEditorStyle> myLocalThemes;
    private final ImmutableList<ThemeEditorStyle> myExternalLibraryThemes;
    private final Configuration myConfiguration;
    private final ResourceResolver myResolver;

    public ThemeResolver(Configuration configuration) {
        this.myConfiguration = configuration;
        this.myResolver = configuration.getResourceResolver();
        if (this.myResolver == null) {
            throw new IllegalArgumentException("Acquired ResourceResolver is null, not an Android module?");
        }
        this.myFrameworkThemes = this.fillThemeResolverFromStyles(this.resolveFrameworkThemes());
        ImmutableList.Builder localThemes = ImmutableList.builder();
        for (Pair<StyleResourceValue, Module> pair : this.resolveLocallyDefinedModuleThemes()) {
            ThemeEditorStyle theme = this.constructThemeFromResourceValue((StyleResourceValue)pair.getFirst(), (Module)pair.getSecond());
            if (theme == null) continue;
            localThemes.add((Object)theme);
        }
        this.myLocalThemes = localThemes.build();
        this.myExternalLibraryThemes = this.fillThemeResolverFromStyles(this.resolveNonFrameworkThemes());
    }

    private ThemeEditorStyle constructThemeFromResourceValue(StyleResourceValue value, Module sourceModule) {
        String name = ResolutionUtils.getQualifiedStyleName(value);
        if (this.myThemeByName.containsKey(name)) {
            return null;
        }
        ThemeEditorStyle theme = ResolutionUtils.getStyle(this.myConfiguration, name, sourceModule);
        if (theme != null) {
            this.myThemeByName.put(name, theme);
        }
        return theme;
    }

    private ImmutableList<ThemeEditorStyle> fillThemeResolverFromStyles(List<StyleResourceValue> source) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StyleResourceValue value : source) {
            ThemeEditorStyle theme = this.constructThemeFromResourceValue(value, null);
            if (theme == null) continue;
            builder.add((Object)theme);
        }
        return builder.build();
    }

    private List<StyleResourceValue> resolveFrameworkThemes() {
        ResourceRepository repository = this.myConfiguration.getFrameworkResources();
        if (repository == null) {
            return Collections.emptyList();
        }
        return this.getThemes((Map)repository.getConfiguredResources(this.myConfiguration.getFullConfig()).get(ResourceType.STYLE), true);
    }

    private List<StyleResourceValue> resolveNonFrameworkThemes() {
        AppResourceRepository repository = AppResourceRepository.getAppResources(this.myConfiguration.getModule(), true);
        if (repository == null) {
            return Collections.emptyList();
        }
        return this.getThemes(repository.getConfiguredResources(ResourceType.STYLE, this.myConfiguration.getFullConfig()), false);
    }

    private List<Pair<StyleResourceValue, Module>> resolveLocallyDefinedModuleThemes() {
        Module module = this.myConfiguration.getModule();
        ArrayList result = Lists.newArrayList();
        this.fillModuleResources(module, ModuleResourceRepository.getModuleResources(module, true), result);
        List<AndroidFacet> allAndroidDependencies = AndroidUtils.getAllAndroidDependencies(module, false);
        for (AndroidFacet facet : allAndroidDependencies) {
            this.fillModuleResources(facet.getModule(), facet.getModuleResources(true), result);
        }
        return result;
    }

    private void fillModuleResources(Module module, LocalResourceRepository repository, List<Pair<StyleResourceValue, Module>> sink) {
        if (repository == null) {
            return;
        }
        for (StyleResourceValue value : this.getThemes(repository.getConfiguredResources(ResourceType.STYLE, this.myConfiguration.getFullConfig()), false)) {
            sink.add((Pair<StyleResourceValue, Module>)Pair.create((Object)value, (Object)module));
        }
    }

    private List<StyleResourceValue> getThemes(Map<String, ResourceValue> styles, boolean isFramework) {
        Collection<ResourceValue> values = styles.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values.size());
        if (!isFramework) {
            HashMap cache = Maps.newHashMapWithExpectedSize((int)values.size());
            for (ResourceValue value : values) {
                StyleResourceValue styleValue;
                if (!(value instanceof StyleResourceValue) || !this.myResolver.isTheme((ResourceValue)(styleValue = (StyleResourceValue)value), (Map)cache)) continue;
                themes.add(styleValue);
            }
            return themes;
        }
        for (ResourceValue value : values) {
            String name = value.getName();
            if (!name.startsWith("Theme.") && !name.equals("Theme")) continue;
            themes.add((StyleResourceValue)value);
        }
        return themes;
    }

    public ThemeEditorStyle getTheme(String themeName) {
        return this.myThemeByName.get(themeName);
    }

    public ImmutableList<ThemeEditorStyle> getLocalThemes() {
        return this.myLocalThemes;
    }

    public ImmutableList<ThemeEditorStyle> getExternalLibraryThemes() {
        return this.myExternalLibraryThemes;
    }

    public ImmutableList<ThemeEditorStyle> getFrameworkThemes() {
        return this.myFrameworkThemes;
    }

    public int getThemesCount() {
        return this.myFrameworkThemes.size() + this.myExternalLibraryThemes.size() + this.myLocalThemes.size();
    }

    Configuration getConfiguration() {
        return this.myConfiguration;
    }
}

