/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.editors.theme.SeparatedList;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JSeparator;

public class ThemesListModel
extends AbstractListModel
implements ComboBoxModel {
    private static final JSeparator SEPARATOR = new JSeparator(0);
    public static final String CREATE_NEW_THEME = "Create New Theme";
    public static final String SHOW_ALL_THEMES = "Show all themes";
    public static final String RENAME = "Rename ";
    private final ThemeEditorContext myContext;
    private final ImmutableList<String> myDefaultThemeNames;
    private final String myDefaultThemeName;
    private SeparatedList myAllItems;
    private String mySelectedObject;
    private final List<String> myEditOptions = new ArrayList<String>();
    private ImmutableList<String> myAvailableProjectThemes;

    public ThemesListModel(ThemeEditorContext context, List<String> defaultThemeNames, String defaultThemeName) {
        this.myContext = context;
        this.myDefaultThemeNames = ImmutableList.copyOf(defaultThemeNames);
        this.myDefaultThemeName = defaultThemeName;
        this.updateThemes();
        this.myContext.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((flags & 0xF6) != 0) {
                    ThemesListModel.this.updateThemes();
                    ThemesListModel.this.fireContentsChanged(this, -1, -1);
                }
                return true;
            }
        });
    }

    private void updateThemes() {
        ImmutableList<String> editableThemes = ThemeEditorUtils.getModuleThemeQualifiedNamesList(this.myContext.getCurrentContextModule());
        ImmutableList.Builder availableThemesListBuilder = ImmutableList.builder();
        ImmutableList.Builder disabledThemesListBuilder = ImmutableList.builder();
        ThemeResolver themeResolver = this.myContext.getThemeResolver();
        for (String themeName : editableThemes) {
            if (themeResolver.getTheme(themeName) != null) {
                availableThemesListBuilder.add((Object)themeName);
                continue;
            }
            disabledThemesListBuilder.add((Object)themeName);
        }
        this.myAvailableProjectThemes = availableThemesListBuilder.build();
        ImmutableList disabledProjectThemes = disabledThemesListBuilder.build();
        String selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            if (this.myDefaultThemeName != null && (editableThemes.contains((Object)this.myDefaultThemeName) || themeResolver.getTheme(this.myDefaultThemeName) != null)) {
                selectedItem = this.myDefaultThemeName;
            } else if (!editableThemes.isEmpty()) {
                selectedItem = (String)editableThemes.get(0);
            } else if (!this.myDefaultThemeNames.isEmpty()) {
                selectedItem = (String)this.myDefaultThemeNames.get(0);
            }
        }
        this.myEditOptions.clear();
        this.buildEditOptionsList(selectedItem);
        this.myAllItems = new SeparatedList(SEPARATOR, SeparatedList.group(this.myAvailableProjectThemes), SeparatedList.group(disabledProjectThemes), SeparatedList.group(this.myDefaultThemeNames, SHOW_ALL_THEMES), SeparatedList.group(this.myEditOptions));
        this.setSelectedItem(selectedItem);
    }

    private void buildEditOptionsList(String selectedItem) {
        this.myEditOptions.clear();
        this.myEditOptions.add(CREATE_NEW_THEME);
        if (selectedItem != null && this.myAvailableProjectThemes.contains((Object)selectedItem)) {
            String simpleName = StringUtil.substringAfter((String)selectedItem, (String)"/");
            assert (simpleName != null);
            this.myEditOptions.add(RENAME + simpleName);
        }
    }

    @Override
    public int getSize() {
        return this.myAllItems.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.myAllItems.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (!(anItem instanceof String)) {
            return;
        }
        this.mySelectedObject = (String)anItem;
        if (!ThemesListModel.isSpecialOption(this.mySelectedObject)) {
            this.buildEditOptionsList(this.mySelectedObject);
        }
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public String getSelectedItem() {
        return this.mySelectedObject;
    }

    public static boolean isSpecialOption(String value) {
        return SHOW_ALL_THEMES.equals(value) || CREATE_NEW_THEME.equals(value) || value.startsWith(RENAME);
    }
}

