/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.swing.ui.SwatchComponent;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColorPaletteComponent
implements Icon {
    private static final int ICON_SIZE = JBUI.scale((int)20);
    private static final int PADDING = JBUI.scale((int)2);
    private Color myPrimaryColor = null;
    private Color myPrimaryDarkColor = null;
    private Color myAccentColor = null;

    public void setValues(Color primaryColor, Color primaryDarkColor, Color accentColor) {
        this.myPrimaryColor = primaryColor;
        this.myPrimaryDarkColor = primaryDarkColor;
        this.myAccentColor = accentColor;
    }

    public void reset() {
        this.myPrimaryColor = null;
        this.myPrimaryDarkColor = null;
        this.myAccentColor = null;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int i, int i1) {
        if (this.myPrimaryColor != null && this.myPrimaryDarkColor != null && this.myAccentColor != null) {
            GraphicsUtil.setupAAPainting((Graphics)graphics);
            Graphics2D g = (Graphics2D)graphics.create();
            new SwatchComponent.ColorIcon(this.myPrimaryColor).paint(component, g, i + PADDING, i1 + PADDING, ICON_SIZE, ICON_SIZE);
            new SwatchComponent.ColorIcon(this.myPrimaryDarkColor).paint(component, g, i + 2 * PADDING + ICON_SIZE, i1 + PADDING, ICON_SIZE, ICON_SIZE);
            new SwatchComponent.ColorIcon(this.myAccentColor).paint(component, g, i + 3 * PADDING + 2 * ICON_SIZE, i1 + PADDING, ICON_SIZE, ICON_SIZE);
            g.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return (ICON_SIZE + PADDING) * 3 + PADDING;
    }

    @Override
    public int getIconHeight() {
        return ICON_SIZE + 2 * PADDING;
    }
}

