/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.swing.ui.SwatchComponent;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;

public class ColorRendererEditor
extends GraphicalResourceRendererEditor {
    public ColorRendererEditor(ThemeEditorContext context, AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        super(context, previewPanel, isEditor);
    }

    @Override
    protected void updateComponent(ThemeEditorContext context, ResourceComponent component, EditedStyleItem item) {
        assert (context.getResourceResolver() != null);
        List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)context.getResourceResolver(), (ResourceValue)item.getSelectedValue(), context.getProject());
        component.setSwatchIcons(SwatchComponent.colorListOf(colors));
        component.setNameText(item.getQualifiedName());
        component.setValueText(item.getValue());
        Set<String> lowContrastColors = ColorUtils.getLowContrastColors(context, item);
        if (!lowContrastColors.isEmpty()) {
            component.setWarningVisible(true);
            StringBuilder contrastErrorMessageBuilder = new StringBuilder("<html>Not enough contrast with ");
            int i = 0;
            for (String color : lowContrastColors) {
                contrastErrorMessageBuilder.append(color);
                if (i < lowContrastColors.size() - 2) {
                    contrastErrorMessageBuilder.append(", ");
                } else if (i == lowContrastColors.size() - 2) {
                    contrastErrorMessageBuilder.append(" and ");
                }
                ++i;
            }
            this.myComponent.setWarning(contrastErrorMessageBuilder.toString());
        } else {
            component.setWarningVisible(false);
        }
    }

    @Override
    protected ResourceType[] getAllowedResourceTypes() {
        AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(this.myContext.getConfiguration(), this.myItem.getSelectedValue());
        String attributeName = this.myItem.getName().toLowerCase();
        if (attributeName.contains("color") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Reference)) {
            return COLORS_ONLY;
        }
        if (attributeName.contains("drawable") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Color)) {
            return DRAWABLES_ONLY;
        }
        return COLORS_AND_DRAWABLES;
    }
}

