/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.swing.ui.SwatchComponent;
import com.intellij.openapi.module.Module;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import org.jetbrains.android.facet.AndroidFacet;

public class DrawableRendererEditor
extends GraphicalResourceRendererEditor {
    private final RenderTask myRenderTask;

    public DrawableRendererEditor(ThemeEditorContext context, AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        super(context, previewPanel, isEditor);
        this.myRenderTask = DrawableRendererEditor.configureRenderTask(context.getCurrentContextModule(), context.getConfiguration());
    }

    public static RenderTask configureRenderTask(Module module, Configuration configuration) {
        RenderTask result = null;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            RenderService service = RenderService.get(facet);
            result = service.createTask(null, configuration, new RenderLogger("ThemeEditorLogger", module), null);
        }
        return result;
    }

    @Override
    protected void updateComponent(ThemeEditorContext context, ResourceComponent component, EditedStyleItem item) {
        assert (context.getResourceResolver() != null);
        if (this.myRenderTask != null) {
            component.setSwatchIcons(SwatchComponent.imageListOf(this.myRenderTask.renderDrawableAllStates((ResourceValue)item.getSelectedValue())));
        }
        String nameText = String.format("<html><nobr><b><font color=\"#%1$s\">%2$s", ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), ThemeEditorUtils.getDisplayHtml(item));
        component.setNameText(nameText);
        component.setValueText(item.getValue());
    }

    @Override
    protected ResourceType[] getAllowedResourceTypes() {
        return GraphicalResourceRendererEditor.DRAWABLES_ONLY;
    }
}

