/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.DumbAwareActionListener;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellEditor;
import com.android.tools.idea.editors.theme.attributes.variants.VariantItemListener;
import com.android.tools.idea.editors.theme.attributes.variants.VariantsComboItem;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.uipreview.ChooseResourceDialog;

public abstract class GraphicalResourceRendererEditor
extends TypedCellEditor<EditedStyleItem, String>
implements TableCellRenderer {
    public static final ResourceType[] COLORS_ONLY = new ResourceType[]{ResourceType.COLOR};
    public static final ResourceType[] DRAWABLES_ONLY = new ResourceType[]{ResourceType.DRAWABLE, ResourceType.MIPMAP};
    public static final ResourceType[] COLORS_AND_DRAWABLES = new ResourceType[]{ResourceType.COLOR, ResourceType.DRAWABLE, ResourceType.MIPMAP};
    static final String DUMB_MODE_MESSAGE = "Editing theme is not possible - indexing is in progress";
    private static final Logger LOG = Logger.getInstance(GraphicalResourceRendererEditor.class);
    private static final Comparator<VariantsComboItem> VARIANTS_COMBO_ITEM_COMPARATOR = new Comparator<VariantsComboItem>(){

        @Override
        public int compare(VariantsComboItem o1, VariantsComboItem o2) {
            FolderConfiguration o1FolderConfiguration = o1.getOriginalConfiguration();
            FolderConfiguration o2FolderConfiguration = o2.getOriginalConfiguration();
            if (o1FolderConfiguration.isDefault() && !o2FolderConfiguration.isDefault()) {
                return -1;
            }
            if (o2FolderConfiguration.isDefault() && !o1FolderConfiguration.isDefault()) {
                return 1;
            }
            return o1FolderConfiguration.toShortDisplayString().compareTo(o2FolderConfiguration.toShortDisplayString());
        }
    };
    protected final ThemeEditorContext myContext;
    protected final ResourceComponent myComponent;
    protected final AndroidThemePreviewPanel myPreviewPanel;
    protected AttributesTableModel myModel;
    protected EditedStyleItem myItem;
    protected String myEditorValue;

    public GraphicalResourceRendererEditor(ThemeEditorContext context, AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        this.myContext = context;
        this.myComponent = new ResourceComponent(){

            @Override
            public boolean isShowing() {
                return true;
            }
        };
        if (isEditor) {
            this.myComponent.addVariantItemListener(new VariantItemListener(context));
            this.myComponent.addVariantItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GraphicalResourceRendererEditor.this.stopCellEditing();
                }
            });
            this.myComponent.addVariantPopupClosingListener(new VariantsComboBox.PopupClosingListener(){

                @Override
                public void popupClosed() {
                    GraphicalResourceRendererEditor.this.stopCellEditing();
                }
            });
            this.myComponent.addActionListener(new EditorClickListener());
        }
        this.myPreviewPanel = previewPanel;
    }

    private static void updateComponentInternal(ResourceComponent component, EditedStyleItem item) {
        String currentVariantColor = ColorUtil.toHex((Color)ThemeEditorConstants.CURRENT_VARIANT_COLOR);
        String notSelectedVariantColor = ColorUtil.toHex((Color)ThemeEditorConstants.NOT_SELECTED_VARIANT_COLOR);
        FolderConfiguration restrictedConfig = QualifierUtils.restrictConfiguration(item.getSelectedItemResourceValue(), item.getAllConfiguredItems());
        String description = String.format("<html><nobr><font color=\"#%1$s\">%2$s", currentVariantColor, item.getSelectedValueConfiguration().toShortDisplayString());
        VariantsComboItem selectedItem = new VariantsComboItem(description, restrictedConfig != null ? restrictedConfig : item.getSelectedValueConfiguration(), item.getSelectedValueConfiguration());
        TreeSet notSelectedItems = Sets.newTreeSet(VARIANTS_COMBO_ITEM_COMPARATOR);
        for (ConfiguredElement<ItemResourceValue> configuredItem : item.getNonSelectedItemResourceValues()) {
            restrictedConfig = QualifierUtils.restrictConfiguration(configuredItem, item.getAllConfiguredItems());
            if (restrictedConfig == null) {
                LOG.warn(String.format("For item '%1$s': Folder configuration '%2$s' can never be selected. There are no qualifiers combination that would allow selecting it.", item.getName(), configuredItem.getConfiguration()));
                continue;
            }
            description = String.format("<html><nobr><b><font color=\"#%1$s\">%2$s</font></b><font color=\"#9B9B9B\"> %3$s</font>", notSelectedVariantColor, configuredItem.getConfiguration().toShortDisplayString(), " - " + configuredItem.getElement().getValue());
            notSelectedItems.add(new VariantsComboItem(description, restrictedConfig, configuredItem.getConfiguration()));
        }
        ImmutableList variantList = ImmutableList.builder().add((Object)selectedItem).addAll((Iterable)notSelectedItems).build();
        component.setVariantsModel((ComboBoxModel)new CollectionComboBoxModel((List)variantList, (Object)selectedItem));
    }

    protected abstract void updateComponent(ThemeEditorContext var1, ResourceComponent var2, EditedStyleItem var3);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        assert (obj instanceof EditedStyleItem) : "Object passed to GraphicalResourceRendererEditor.getTableCellRendererComponent must be instance of EditedStyleItem";
        this.myItem = (EditedStyleItem)obj;
        this.myComponent.setSize(table.getCellRect(row, column, false).getSize());
        GraphicalResourceRendererEditor.updateComponentInternal(this.myComponent, (EditedStyleItem)obj);
        this.updateComponent(this.myContext, this.myComponent, (EditedStyleItem)obj);
        return this.myComponent;
    }

    @Override
    public Component getEditorComponent(JTable table, EditedStyleItem value, boolean isSelected, int row, int column) {
        this.myModel = (AttributesTableModel)table.getModel();
        this.myItem = value;
        this.myComponent.setSize(table.getCellRect(row, column, false).getSize());
        GraphicalResourceRendererEditor.updateComponentInternal(this.myComponent, value);
        this.updateComponent(this.myContext, this.myComponent, value);
        this.myEditorValue = null;
        return this.myComponent;
    }

    @Override
    public String getEditorValue() {
        return this.myEditorValue;
    }

    protected abstract ResourceType[] getAllowedResourceTypes();

    private class EditorClickListener
    extends DumbAwareActionListener {
        public EditorClickListener() {
            super(GraphicalResourceRendererEditor.this.myContext.getProject());
        }

        @Override
        public void dumbActionPerformed(ActionEvent e) {
            DumbService.getInstance((Project)GraphicalResourceRendererEditor.this.myContext.getProject()).showDumbModeNotification(GraphicalResourceRendererEditor.DUMB_MODE_MESSAGE);
            GraphicalResourceRendererEditor.this.cancelCellEditing();
        }

        @Override
        public void smartActionPerformed(ActionEvent e) {
            ThemeEditorStyle style = GraphicalResourceRendererEditor.this.myModel.getSelectedStyle();
            ResourceResolver styleResourceResolver = GraphicalResourceRendererEditor.this.myContext.getConfiguration().getResourceResolver();
            assert (styleResourceResolver != null);
            ItemResourceValue primaryColorResourceValue = ThemeEditorUtils.resolveItemFromParents(style, "colorPrimary", !ThemeEditorUtils.isAppCompatTheme(style));
            Color primaryColor = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, (ResourceValue)primaryColorResourceValue, GraphicalResourceRendererEditor.this.myContext.getProject());
            ChooseResourceDialog dialog = ThemeEditorUtils.getResourceDialog(GraphicalResourceRendererEditor.this.myItem, GraphicalResourceRendererEditor.this.myContext, GraphicalResourceRendererEditor.this.getAllowedResourceTypes());
            if (primaryColor != null) {
                dialog.generateColorSuggestions(primaryColor, GraphicalResourceRendererEditor.this.myItem.getName());
            }
            final String oldValue = GraphicalResourceRendererEditor.this.myItem.getSelectedValue().getValue();
            dialog.setResourcePickerListener(new ChooseResourceDialog.ResourcePickerListener(){

                @Override
                public void resourceChanged(String resource) {
                    if (resource != null) {
                        ResourceResolver resourceResolver = GraphicalResourceRendererEditor.this.myContext.getConfiguration().getResourceResolver();
                        assert (resourceResolver != null);
                        ResourceValue resValue = resourceResolver.findResValue(resource, false);
                        String resolvedResource = resource;
                        if (resValue != null && resValue.getResourceType() == ResourceType.COLOR && !resValue.getValue().endsWith(".xml")) {
                            resolvedResource = ResourceHelper.colorToString(ResourceHelper.resolveColor((RenderResources)resourceResolver, resValue, GraphicalResourceRendererEditor.this.myContext.getProject()));
                        }
                        GraphicalResourceRendererEditor.this.myItem.getSelectedValue().setValue(resolvedResource);
                    } else {
                        GraphicalResourceRendererEditor.this.myItem.getSelectedValue().setValue(oldValue);
                    }
                    GraphicalResourceRendererEditor.this.myPreviewPanel.invalidateGraphicsRenderer();
                }
            });
            if (e.getSource() instanceof JBMenuItem) {
                dialog.openLocationSettings();
            }
            dialog.show();
            GraphicalResourceRendererEditor.this.myItem.getSelectedValue().setValue(oldValue);
            GraphicalResourceRendererEditor.this.myEditorValue = null;
            if (dialog.isOK()) {
                String value = dialog.getResourceName();
                if (value != null) {
                    GraphicalResourceRendererEditor.this.myEditorValue = dialog.getResourceName();
                }
            } else {
                GraphicalResourceRendererEditor.this.myPreviewPanel.invalidateGraphicsRenderer();
            }
            if (GraphicalResourceRendererEditor.this.myEditorValue == null) {
                GraphicalResourceRendererEditor.this.cancelCellEditing();
            } else {
                GraphicalResourceRendererEditor.this.stopCellEditing();
            }
        }
    }
}

