/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.ThemesListModel;
import com.android.tools.idea.editors.theme.attributes.editors.ColorPaletteComponent;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListCellRenderer;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.rendering.ResourceHelper;
import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.JList;

public class StyleListPaletteCellRenderer
extends StyleListCellRenderer {
    private static final String PRIMARY_MATERIAL = "colorPrimary";
    private static final String PRIMARY_DARK_MATERIAL = "colorPrimaryDark";
    private static final String ACCENT_MATERIAL = "colorAccent";
    private ColorPaletteComponent myColorPaletteComponent = null;
    private final ItemHoverListener myItemHoverListener;
    private final ThemeEditorContext myContext;

    public StyleListPaletteCellRenderer(ThemeEditorContext context, ItemHoverListener itemHoverListener, JComboBox comboBox) {
        super(context, comboBox);
        this.myContext = context;
        this.myColorPaletteComponent = new ColorPaletteComponent();
        this.myItemHoverListener = itemHoverListener;
    }

    @Override
    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        super.customizeCellRenderer(list, value, index, selected, hasFocus);
        if (!(value instanceof String) || ThemesListModel.isSpecialOption((String)value)) {
            this.myColorPaletteComponent.reset();
            return;
        }
        ThemeResolver themeResolver = this.myContext.getThemeResolver();
        ThemeEditorStyle theme = themeResolver.getTheme((String)value);
        if (theme == null) {
            this.myColorPaletteComponent.reset();
            this.setIcon(null);
            return;
        }
        boolean isFrameworkAttr = !ThemeEditorUtils.isAppCompatTheme(theme);
        ItemResourceValue primaryResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, PRIMARY_MATERIAL, isFrameworkAttr);
        ItemResourceValue primaryDarkResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, PRIMARY_DARK_MATERIAL, isFrameworkAttr);
        ItemResourceValue accentResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, ACCENT_MATERIAL, isFrameworkAttr);
        if (primaryResourceValue != null && primaryDarkResourceValue != null && accentResourceValue != null) {
            Configuration configuration = theme.getConfiguration();
            ResourceResolver resourceResolver = configuration.getConfigurationManager().getResolverCache().getResourceResolver(configuration.getTarget(), theme.getQualifiedName(), configuration.getFullConfig());
            Color primaryColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)primaryResourceValue, this.myContext.getProject());
            Color primaryDarkColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)primaryDarkResourceValue, this.myContext.getProject());
            Color accentColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)accentResourceValue, this.myContext.getProject());
            if (primaryColor != null && primaryDarkColor != null && accentColor != null) {
                this.myColorPaletteComponent.setValues(primaryColor, primaryDarkColor, accentColor);
            }
            this.setIcon(this.myColorPaletteComponent);
        } else {
            this.myColorPaletteComponent.reset();
            this.setIcon(null);
        }
        if (selected) {
            this.myItemHoverListener.itemHovered(theme.getQualifiedName());
        }
    }

    public static interface ItemHoverListener {
        public void itemHovered(String var1);
    }
}

