/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.ui;

import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.android.tools.swing.ui.ClickableLabel;
import com.android.tools.swing.ui.SwatchComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class ResourceComponent
extends JPanel {
    private static final short MAX_SWATCH_ICONS = 3;
    public static final String NAME_LABEL = "Name Label";
    private final SwatchComponent mySwatchComponent = new SwatchComponent(3);
    private final ClickableLabel myNameLabel = new ClickableLabel();
    protected final ClickableLabel myWarningLabel = new ClickableLabel();
    private final VariantsComboBox myVariantCombo = new VariantsComboBox();

    public ResourceComponent() {
        super(new BorderLayout(0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP));
        this.setBorder(BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0, ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0));
        this.myWarningLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myWarningLabel.setVisible(false);
        this.myNameLabel.setName(NAME_LABEL);
        this.myNameLabel.setForeground((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR);
        this.myNameLabel.setFont(this.myNameLabel.getFont().deriveFont(1));
        Box topRowPanel = new Box(2);
        topRowPanel.add(this.myNameLabel);
        topRowPanel.add(this.myWarningLabel);
        topRowPanel.add(Box.createHorizontalGlue());
        topRowPanel.add(this.myVariantCombo);
        this.add((Component)topRowPanel, "Center");
        this.mySwatchComponent.setBackground((Color)JBColor.WHITE);
        this.mySwatchComponent.setForeground(null);
        this.add((Component)this.mySwatchComponent, "South");
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int firstRowHeight = Math.max(this.getFontMetrics(this.getFont()).getHeight(), this.myVariantCombo.getPreferredSize().height);
            int secondRowHeight = this.mySwatchComponent.getPreferredSize().height;
            return new Dimension(0, ThemeEditorConstants.ATTRIBUTE_MARGIN + ThemeEditorConstants.ATTRIBUTE_ROW_GAP + firstRowHeight + secondRowHeight);
        }
        return super.getPreferredSize();
    }

    public void setSwatchIcons(List<SwatchComponent.SwatchIcon> icons) {
        this.mySwatchComponent.setSwatchIcons(icons);
    }

    public void setNameText(String name) {
        this.myNameLabel.setText(name);
    }

    public void setWarning(String warning) {
        this.myWarningLabel.setToolTipText(warning);
    }

    public void setWarningVisible(boolean isVisible) {
        this.myWarningLabel.setVisible(isVisible);
    }

    public void setVariantsModel(ComboBoxModel comboBoxModel) {
        this.myVariantCombo.setModel(comboBoxModel != null ? comboBoxModel : new DefaultComboBoxModel());
    }

    public void addVariantItemListener(ItemListener itemListener) {
        this.myVariantCombo.addItemListener(itemListener);
    }

    public void addVariantPopupClosingListener(VariantsComboBox.PopupClosingListener listener) {
        this.myVariantCombo.addPopupClosingListener(listener);
    }

    public void setValueText(String value) {
        this.mySwatchComponent.setText(value);
    }

    public String getValueText() {
        return this.mySwatchComponent.getText();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.mySwatchComponent != null) {
            this.mySwatchComponent.setFont(font);
        }
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu popup) {
        super.setComponentPopupMenu(popup);
        this.myNameLabel.setComponentPopupMenu(popup);
        this.mySwatchComponent.setComponentPopupMenu(popup);
    }

    public void addActionListener(final ActionListener listener) {
        this.myNameLabel.addActionListener(listener);
        this.myWarningLabel.addActionListener(listener);
        this.mySwatchComponent.addActionListener(listener);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!ResourceComponent.this.contains(e.getPoint()) || !SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                listener.actionPerformed(new ActionEvent(e.getSource(), 1001, null));
            }
        });
    }

    public void setVariantComboVisible(boolean isVisible) {
        this.myVariantCombo.setVisible(isVisible);
    }

    public ValidationInfo createSwatchValidationInfo(String errorText) {
        return new ValidationInfo(errorText, (JComponent)this.mySwatchComponent);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myWarningLabel.isVisible()) {
            this.validate();
            if (SwingUtilities.getLocalBounds(this.myWarningLabel).contains(SwingUtilities.convertMouseEvent(this, event, this.myWarningLabel).getPoint())) {
                return this.myWarningLabel.getToolTipText();
            }
        }
        return super.getToolTipText(event);
    }
}

