/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.vmtrace.treemodel;

import com.android.tools.idea.editors.vmtrace.treemodel.StatsNode;
import com.android.tools.idea.editors.vmtrace.treemodel.StatsTableColumn;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.MethodProfileData;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.intellij.openapi.util.Pair;
import java.util.concurrent.TimeUnit;

public abstract class AbstractProfileDataNode
implements StatsNode {
    protected abstract MethodProfileData getProfileData();

    protected Object renderColumn(StatsTableColumn column, ThreadInfo thread, VmTraceData traceData, ClockType clock) {
        MethodProfileData profileData = this.getProfileData();
        switch (column) {
            case NAME: {
                return null;
            }
            case INCLUSIVE_TIME: {
                long inclusiveTimeNs = profileData == null ? 0L : profileData.getInclusiveTime(thread, clock, TimeUnit.NANOSECONDS);
                return AbstractProfileDataNode.getValueAndPercentagePair(thread, traceData, clock, inclusiveTimeNs);
            }
            case EXCLUSIVE_TIME: {
                long inclusiveTimeNs = profileData == null ? 0L : profileData.getExclusiveTime(thread, clock, TimeUnit.NANOSECONDS);
                return AbstractProfileDataNode.getValueAndPercentagePair(thread, traceData, clock, inclusiveTimeNs);
            }
            case INVOCATION_COUNT: {
                return profileData == null ? 0L : profileData.getInvocationCount(thread);
            }
        }
        return "";
    }

    private static Pair<Long, Double> getValueAndPercentagePair(ThreadInfo thread, VmTraceData traceData, ClockType clock, long timeNanos) {
        double percent = traceData.getDurationPercentage(timeNanos, thread, clock) / 100.0;
        long timeMicros = TimeUnit.MICROSECONDS.convert(timeNanos, TimeUnit.NANOSECONDS);
        return Pair.create((Object)timeMicros, (Object)percent);
    }
}

