/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Lists;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.List;
import net.jcip.annotations.GuardedBy;

public class GradleSyncState {
    private static final Logger LOG = Logger.getInstance(GradleSyncState.class);
    private static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"Gradle sync");
    private static final List<String> PROJECT_PREFERENCES_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsConfigurable", "com.intellij.uiDesigner.GuiDesignerConfigurable", "org.jetbrains.plugins.groovy.gant.GantConfigurable", "org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfigurable", "org.jetbrains.android.compiler.AndroidDexCompilerSettingsConfigurable", "org.jetbrains.idea.maven.utils.MavenSettings", "com.intellij.compiler.options.CompilerConfigurable"});
    private static final Topic<GradleSyncListener> GRADLE_SYNC_TOPIC = new Topic("Project sync with Gradle", GradleSyncListener.class);
    private static final Key<Long> PROJECT_LAST_SYNC_TIMESTAMP_KEY = Key.create((String)"android.gradle.project.last.sync.timestamp");
    private final Project myProject;
    private final MessageBus myMessageBus;
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private boolean mySyncNotificationsEnabled;
    @GuardedBy(value="myLock")
    private boolean mySyncInProgress;

    public static void subscribe(Project project, GradleSyncListener listener) {
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(GRADLE_SYNC_TOPIC, (Object)listener);
    }

    public static GradleSyncState getInstance(Project project) {
        return (GradleSyncState)ServiceManager.getService((Project)project, GradleSyncState.class);
    }

    public GradleSyncState(Project project, MessageBus messageBus) {
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areSyncNotificationsEnabled() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncNotificationsEnabled;
        }
    }

    public void syncSkipped(long lastSyncTimestamp) {
        LOG.info(String.format("Skipped sync with Gradle for project '%1$s'. Data model(s) loaded from cache.", this.myProject.getName()));
        this.cleanUpProjectPreferences();
        this.setLastGradleSyncTimestamp(lastSyncTimestamp);
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSkipped(GradleSyncState.this.myProject);
            }
        });
        this.enableNotifications();
        GradleSyncState.trackSyncEvent("syncSkipped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncStarted(boolean notifyUser) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySyncInProgress) {
                LOG.info(String.format("Sync already in progress for project '%1$s'.", this.myProject.getName()));
                return false;
            }
            this.mySyncInProgress = true;
        }
        LOG.info(String.format("Started sync with Gradle for project '%1$s'.", this.myProject.getName()));
        this.addInfoToEventLog("Gradle sync started");
        this.cleanUpProjectPreferences();
        if (notifyUser) {
            this.notifyUser();
        }
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncStarted(GradleSyncState.this.myProject);
            }
        });
        GradleSyncState.trackSyncEvent("syncStarted");
        return true;
    }

    public void syncFailed(final String message) {
        LOG.info(String.format("Sync with Gradle for project '%1$s' failed: %2$s", this.myProject.getName(), message));
        String logMsg = "Gradle sync failed";
        if (StringUtil.isNotEmpty((String)message)) {
            logMsg = logMsg + String.format(": %1$s", message);
        }
        this.addToEventLog(logMsg, MessageType.ERROR);
        this.syncFinished();
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncFailed(GradleSyncState.this.myProject, message);
            }
        });
        GradleSyncState.trackSyncEvent("syncFailed");
    }

    public void syncEnded() {
        LOG.info(String.format("Sync with Gradle successful for project '%1$s'.", this.myProject.getName()));
        this.addInfoToEventLog("Gradle sync completed");
        LintUtils.sTryPrefixLookup = true;
        this.syncFinished();
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSucceeded(GradleSyncState.this.myProject);
            }
        });
        FullRevision gradleVersion = GradleUtil.getGradleVersion(this.myProject);
        if (gradleVersion != null) {
            GradleSyncState.trackSyncEvent("gradleVersion", gradleVersion.toString());
        }
        GradleSyncState.trackSyncEvent("syncEnded");
    }

    private static void trackSyncEvent(String event) {
        GradleSyncState.trackSyncEvent(event, null);
    }

    private static void trackSyncEvent(String event, String extraInfo) {
        UsageTracker.getInstance().trackEvent("gradle", event, extraInfo, null);
    }

    private void addInfoToEventLog(String message) {
        this.addToEventLog(message, MessageType.INFO);
    }

    private void addToEventLog(String message, MessageType type) {
        LOGGING_NOTIFICATION.createNotification(message, type).notify(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFinished() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncInProgress = false;
        }
        this.setLastGradleSyncTimestamp(System.currentTimeMillis());
        this.enableNotifications();
        this.notifyUser();
    }

    private void syncPublisher(Runnable publishingTask) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)publishingTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableNotifications() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncNotificationsEnabled = true;
        }
    }

    public void notifyUser() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                VirtualFile[] files;
                EditorNotifications notifications = EditorNotifications.getInstance((Project)GradleSyncState.this.myProject);
                for (VirtualFile file : files = FileEditorManager.getInstance((Project)GradleSyncState.this.myProject).getOpenFiles()) {
                    try {
                        notifications.updateNotifications(file);
                    }
                    catch (Throwable e) {
                        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
                        String msg = String.format("Failed to update editor notifications for file '%1$s'", filePath);
                        LOG.info(msg, e);
                    }
                }
                BuildVariantView.getInstance(GradleSyncState.this.myProject).updateContents();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncInProgress;
        }
    }

    private void setLastGradleSyncTimestamp(long timestamp) {
        this.myProject.putUserData(PROJECT_LAST_SYNC_TIMESTAMP_KEY, (Object)timestamp);
    }

    public long getLastGradleSyncTimestamp() {
        Long timestamp = (Long)this.myProject.getUserData(PROJECT_LAST_SYNC_TIMESTAMP_KEY);
        return timestamp != null ? timestamp : -1L;
    }

    public ThreeState isSyncNeeded() {
        long lastSync = this.getLastGradleSyncTimestamp();
        if (lastSync < 0L) {
            return ThreeState.UNSURE;
        }
        return this.isSyncNeeded(lastSync) ? ThreeState.YES : ThreeState.NO;
    }

    private boolean isSyncNeeded(long referenceTimeInMillis) {
        assert (referenceTimeInMillis > 0L);
        if (this.isSyncInProgress()) {
            return false;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        File settingsFilePath = new File(Projects.getBaseDirPath(this.myProject), "settings.gradle");
        if (settingsFilePath.exists()) {
            VirtualFile settingsFile = VfsUtil.findFileByIoFile((File)settingsFilePath, (boolean)true);
            if (settingsFile != null && fileDocumentManager.isFileModified(settingsFile)) {
                return true;
            }
            if (settingsFilePath.lastModified() > referenceTimeInMillis) {
                return true;
            }
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            if (buildFile == null) continue;
            if (fileDocumentManager.isFileModified(buildFile)) {
                return true;
            }
            File buildFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile);
            if (buildFilePath.lastModified() <= referenceTimeInMillis) continue;
            return true;
        }
        return false;
    }

    private void cleanUpProjectPreferences() {
        if (!AndroidStudioInitializer.isAndroidStudio()) {
            return;
        }
        try {
            ExtensionPoint projectConfigurable = Extensions.getArea((AreaInstance)this.myProject).getExtensionPoint(Configurable.PROJECT_CONFIGURABLE);
            GradleUtil.cleanUpPreferences((ExtensionPoint<ConfigurableEP<Configurable>>)projectConfigurable, PROJECT_PREFERENCES_TO_REMOVE);
        }
        catch (Throwable e) {
            String msg = String.format("Failed to clean up preferences for project '%1$s'", this.myProject.getName());
            LOG.info(msg, e);
        }
    }
}

