/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer;

import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.util.FilePaths;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class AbstractContentRootModuleCustomizer<T>
implements ModuleCustomizer<T> {
    @Override
    public void customizeModule(Project project, ModifiableRootModel moduleModel, T externalProjectModel) {
        if (externalProjectModel == null) {
            return;
        }
        for (ContentEntry contentEntry : moduleModel.getContentEntries()) {
            moduleModel.removeContentEntry(contentEntry);
        }
        Collection<ContentEntry> contentEntries = this.findOrCreateContentEntries(moduleModel, externalProjectModel);
        ArrayList orphans = Lists.newArrayList();
        this.setUpContentEntries(moduleModel, contentEntries, externalProjectModel, orphans);
        for (RootSourceFolder orphan : orphans) {
            File path = orphan.getPath();
            ContentEntry contentEntry = moduleModel.addContentEntry(FilePaths.pathToIdeaUrl(path));
            AbstractContentRootModuleCustomizer.addSourceFolder(contentEntry, path, orphan.getType(), orphan.isGenerated());
        }
    }

    protected abstract Collection<ContentEntry> findOrCreateContentEntries(ModifiableRootModel var1, T var2);

    protected abstract void setUpContentEntries(ModifiableRootModel var1, Collection<ContentEntry> var2, T var3, List<RootSourceFolder> var4);

    protected void addSourceFolder(Collection<ContentEntry> contentEntries, File folderPath, JpsModuleSourceRootType type, boolean generated, List<RootSourceFolder> orphans) {
        ContentEntry parent = FilePaths.findParentContentEntry(folderPath, contentEntries);
        if (parent == null) {
            orphans.add(new RootSourceFolder(folderPath, type, generated));
            return;
        }
        AbstractContentRootModuleCustomizer.addSourceFolder(parent, folderPath, type, generated);
    }

    private static void addSourceFolder(ContentEntry contentEntry, File folderPath, JpsModuleSourceRootType type, boolean generated) {
        JpsModuleSourceRoot sourceRoot;
        JpsElement properties;
        String url = FilePaths.pathToIdeaUrl(folderPath);
        SourceFolder sourceFolder = contentEntry.addSourceFolder(url, type);
        if (generated && (properties = (sourceRoot = sourceFolder.getJpsElement()).getProperties()) instanceof JavaSourceRootProperties) {
            ((JavaSourceRootProperties)properties).setForGeneratedSources(true);
        }
    }

    protected boolean addExcludedFolder(ContentEntry contentEntry, File dirPath) {
        if (!FilePaths.isPathInContentEntry(dirPath, contentEntry)) {
            return false;
        }
        contentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(dirPath));
        return true;
    }

    protected static class RootSourceFolder {
        private final File myPath;
        private final JpsModuleSourceRootType myType;
        private final boolean myGenerated;

        protected RootSourceFolder(File path, JpsModuleSourceRootType type, boolean generated) {
            this.myPath = path;
            this.myType = type;
            this.myGenerated = generated;
        }

        protected File getPath() {
            return this.myPath;
        }

        protected JpsModuleSourceRootType getType() {
            return this.myType;
        }

        protected boolean isGenerated() {
            return this.myGenerated;
        }
    }
}

