/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer;

import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDependenciesModuleCustomizer<T>
implements ModuleCustomizer<T> {
    @Override
    public void customizeModule(Project project, ModifiableRootModel moduleModel, T externalProjectModel) {
        if (externalProjectModel == null) {
            return;
        }
        AbstractDependenciesModuleCustomizer.removeExistingDependencies(moduleModel);
        this.setUpDependencies(moduleModel, externalProjectModel);
    }

    protected abstract void setUpDependencies(ModifiableRootModel var1, T var2);

    protected DependencySetupErrors getSetupErrors(Project project) {
        DependencySetupErrors setupErrors = Projects.getDependencySetupErrors(project);
        if (setupErrors == null) {
            setupErrors = new DependencySetupErrors();
            Projects.setDependencySetupErrors(project, setupErrors);
        }
        return setupErrors;
    }

    private static void removeExistingDependencies(ModifiableRootModel model) {
        DependencyRemover dependencyRemover = new DependencyRemover(model);
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            orderEntry.accept((RootPolicy)dependencyRemover, null);
        }
    }

    protected static void setUpLibraryDependency(ModifiableRootModel model, String libraryName, DependencyScope scope, Collection<String> binaryPaths) {
        List<String> empty = Collections.emptyList();
        AbstractDependenciesModuleCustomizer.setUpLibraryDependency(model, libraryName, scope, binaryPaths, empty, empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setUpLibraryDependency(ModifiableRootModel model, String libraryName, DependencyScope scope, Collection<String> binaryPaths, Collection<String> sourcePaths, Collection<String> documentationPaths) {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)model.getProject());
        Library library = libraryTable.getLibraryByName(libraryName);
        if (library == null) {
            LibraryTable.ModifiableModel libraryTableModel = libraryTable.getModifiableModel();
            try {
                library = libraryTableModel.createLibrary(libraryName);
                AbstractDependenciesModuleCustomizer.updateLibraryBinaryPaths(library, binaryPaths);
            }
            finally {
                libraryTableModel.commit();
            }
        }
        AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, sourcePaths, OrderRootType.SOURCES);
        AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, documentationPaths, JavadocOrderRootType.getInstance());
        for (String binaryPath : binaryPaths) {
            File annotations;
            if (!binaryPath.endsWith("res") || binaryPath.length() <= "res".length() || binaryPath.charAt(binaryPath.length() - "res".length() - 1) != File.separatorChar || !(annotations = new File(binaryPath.substring(0, binaryPath.length() - "res".length()), "annotations.zip")).isFile()) continue;
            AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, Collections.singletonList(annotations.getPath()), AnnotationOrderRootType.getInstance());
        }
        LibraryOrderEntry orderEntry = model.addLibraryEntry(library);
        orderEntry.setScope(scope);
        orderEntry.setExported(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLibraryBinaryPaths(Library library, Collection<String> binaryPaths) {
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        try {
            for (String path : binaryPaths) {
                String url = AbstractDependenciesModuleCustomizer.pathToUrl(path);
                libraryModel.addRoot(url, OrderRootType.CLASSES);
            }
        }
        finally {
            libraryModel.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLibrarySourcesIfAbsent(Library library, Collection<String> paths, OrderRootType pathType) {
        if (paths.isEmpty() || library.getFiles(pathType).length > 0) {
            return;
        }
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        try {
            for (String path : paths) {
                libraryModel.addRoot(AbstractDependenciesModuleCustomizer.pathToUrl(path), pathType);
            }
        }
        finally {
            libraryModel.commit();
        }
    }

    public static String pathToUrl(String path) {
        File file = new File(path);
        String name = file.getName();
        boolean isJarFile = FileUtilRt.extensionEquals((String)name, (String)"jar") || FileUtilRt.extensionEquals((String)name, (String)"zip");
        String protocol = isJarFile ? "jar" : "file";
        String url = VirtualFileManager.constructUrl((String)protocol, (String)FileUtil.toSystemIndependentName((String)file.getPath()));
        if (isJarFile) {
            url = url + "!/";
        }
        return url;
    }

    private static class DependencyRemover
    extends RootPolicy<Object> {
        private final ModifiableRootModel myModel;

        DependencyRemover(ModifiableRootModel model) {
            this.myModel = model;
        }

        public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value) {
            this.myModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
            return value;
        }

        public Object visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Object value) {
            this.myModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
            return value;
        }
    }
}

