/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidProject;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.Collection;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class AndroidSdkModuleCustomizer
implements ModuleCustomizer<AndroidGradleModel> {
    private static final Logger LOG = Logger.getInstance(AndroidSdkModuleCustomizer.class);

    @Override
    public void customizeModule(Project project, ModifiableRootModel moduleModel, AndroidGradleModel androidModel) {
        AndroidProject androidProject;
        String compileTarget;
        Sdk sdk;
        if (androidModel == null) {
            return;
        }
        File androidSdkHomePath = IdeSdks.getAndroidSdkPath();
        if (androidSdkHomePath == null) {
            return;
        }
        LanguageLevel languageLevel = androidModel.getJavaLanguageLevel();
        if (languageLevel != null) {
            ((LanguageLevelModuleExtensionImpl)moduleModel.getModuleExtension(LanguageLevelModuleExtensionImpl.class)).setLanguageLevel(languageLevel);
        }
        if ((sdk = AndroidSdkUtils.findSuitableAndroidSdk(compileTarget = (androidProject = androidModel.getAndroidProject()).getCompileTarget())) == null && (sdk = AndroidSdkUtils.tryToCreateAndroidSdk(androidSdkHomePath, compileTarget)) == null) {
            sdk = AndroidSdkModuleCustomizer.findMatchingSdkForAddon(androidProject);
        }
        if (sdk != null) {
            moduleModel.setSdk(sdk);
            return;
        }
        String text = String.format("Module '%1$s': platform '%2$s' not found.", moduleModel.getModule().getName(), compileTarget);
        LOG.info(text);
        Message msg = new Message("Failed to set up SDK", Message.Type.ERROR, text);
        ProjectSyncMessages.getInstance(project).add(msg, new NotificationHyperlink[0]);
    }

    private static Sdk findMatchingSdkForAddon(AndroidProject androidProject) {
        File androidJarPath = null;
        Collection bootClasspath = androidProject.getBootClasspath();
        for (String entry : bootClasspath) {
            File file = new File(entry);
            if (!"android.jar".equals(file.getName())) continue;
            androidJarPath = file;
            break;
        }
        if (androidJarPath != null && bootClasspath.size() > 1) {
            for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
                for (VirtualFile sdkFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                    File sdkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile);
                    if (!FileUtil.filesEqual((File)sdkFilePath, (File)androidJarPath)) continue;
                    return sdk;
                }
            }
        }
        return null;
    }
}

