/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.AbstractCompileOutputModuleCustomizer;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;

public class CompilerOutputModuleCustomizer
extends AbstractCompileOutputModuleCustomizer<AndroidGradleModel>
implements BuildVariantModuleCustomizer<AndroidGradleModel> {
    @Override
    public void customizeModule(Project project, ModifiableRootModel moduleModel, AndroidGradleModel androidModel) {
        if (androidModel == null) {
            return;
        }
        String modelVersion = androidModel.getAndroidProject().getModelVersion();
        if (StringUtil.isEmpty((String)modelVersion)) {
            return;
        }
        Variant selectedVariant = androidModel.getSelectedVariant();
        File mainClassesFolder = selectedVariant.getMainArtifact().getClassesFolder();
        BaseArtifact testArtifact = androidModel.findSelectedTestArtifact(selectedVariant);
        File testClassesFolder = testArtifact == null ? null : testArtifact.getClassesFolder();
        this.setOutputPaths(moduleModel, mainClassesFolder, testClassesFolder);
    }

    @Override
    public ProjectSystemId getProjectSystemId() {
        return ProjectSystemId.IDE;
    }

    @Override
    public Class<AndroidGradleModel> getSupportedModelType() {
        return AndroidGradleModel.class;
    }
}

