/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.dependency;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.customizer.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Dependency {
    static final List<DependencyScope> SUPPORTED_SCOPES = Lists.newArrayList((Object[])new DependencyScope[]{DependencyScope.COMPILE, DependencyScope.TEST});
    private DependencyScope myScope;

    Dependency() {
        this(DependencyScope.COMPILE);
    }

    Dependency(DependencyScope scope) throws IllegalArgumentException {
        this.setScope(scope);
    }

    public final DependencyScope getScope() {
        return this.myScope;
    }

    void setScope(DependencyScope scope) throws IllegalArgumentException {
        if (!SUPPORTED_SCOPES.contains(scope)) {
            String msg = String.format("'%1$s' is not a supported scope. Supported scopes are %2$s.", scope, SUPPORTED_SCOPES);
            throw new IllegalArgumentException(msg);
        }
        this.myScope = scope;
    }

    public static DependencySet extractFrom(AndroidGradleModel androidProject) {
        DependencySet dependencies = new DependencySet();
        BaseArtifact testArtifact = androidProject.findSelectedTestArtifactInSelectedVariant();
        if (testArtifact != null) {
            Dependency.populate(dependencies, testArtifact, DependencyScope.TEST);
        }
        AndroidArtifact mainArtifact = androidProject.getMainArtifact();
        Dependency.populate(dependencies, (BaseArtifact)mainArtifact, DependencyScope.COMPILE);
        return dependencies;
    }

    private static void populate(DependencySet dependencies, BaseArtifact artifact, DependencyScope scope) {
        Dependency.addJavaLibraries(dependencies, artifact.getDependencies().getJavaLibraries(), scope);
        HashSet unique = Sets.newHashSet();
        for (AndroidLibrary lib : artifact.getDependencies().getLibraries()) {
            ModuleDependency mainDependency = null;
            String gradleProjectPath = lib.getProject();
            if (StringUtil.isNotEmpty((String)gradleProjectPath)) {
                mainDependency = new ModuleDependency(gradleProjectPath, scope);
                dependencies.add(mainDependency);
            }
            if (mainDependency == null) {
                Dependency.addLibrary(lib, dependencies, scope, unique);
                continue;
            }
            LibraryDependency backup = Dependency.createLibraryDependency(lib, scope);
            mainDependency.setBackupDependency(backup);
        }
        for (String gradleProjectPath : artifact.getDependencies().getProjects()) {
            if (gradleProjectPath == null || gradleProjectPath.isEmpty()) continue;
            ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
            dependencies.add(dependency);
        }
    }

    private static String getLibraryName(AndroidLibrary library) {
        MavenCoordinates coordinates = library.getResolvedCoordinates();
        if (coordinates != null) {
            return coordinates.getArtifactId() + "-" + coordinates.getVersion();
        }
        File bundle = library.getBundle();
        return FileUtil.getNameWithoutExtension((File)bundle);
    }

    private static void addLibrary(AndroidLibrary library, DependencySet dependencies, DependencyScope scope, Set<File> unique) {
        File folder = library.getFolder();
        if (unique.contains(folder)) {
            return;
        }
        unique.add(folder);
        LibraryDependency dependency = Dependency.createLibraryDependency(library, scope);
        dependencies.add(dependency);
        for (AndroidLibrary dependentLibrary : library.getLibraryDependencies()) {
            Dependency.addLibrary(dependentLibrary, dependencies, scope, unique);
        }
    }

    private static LibraryDependency createLibraryDependency(AndroidLibrary library, DependencyScope scope) {
        LibraryDependency dependency = new LibraryDependency(Dependency.getLibraryName(library), scope);
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getJarFile());
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getResFolder());
        for (File localJar : library.getLocalJars()) {
            dependency.addPath(LibraryDependency.PathType.BINARY, localJar);
        }
        VirtualFile sourceJar = GradleUtil.findSourceJarForLibrary(library.getBundle());
        if (sourceJar != null) {
            File sourceJarFile = VfsUtilCore.virtualToIoFile((VirtualFile)sourceJar);
            dependency.addPath(LibraryDependency.PathType.SOURCE, sourceJarFile);
        }
        return dependency;
    }

    private static void addJavaLibraries(DependencySet dependencies, Collection<JavaLibrary> libraries, DependencyScope scope) {
        for (JavaLibrary library : libraries) {
            File jar = library.getJarFile();
            dependencies.add(new LibraryDependency(jar, scope));
        }
    }
}

