/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.dependency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencySetupErrors {
    private final Map<String, MissingModule> myMissingModules = Maps.newHashMap();
    private final Map<String, MissingModule> myMissingModulesWithBackupLibraries = Maps.newHashMap();
    private final Set<String> myDependentsOnModulesWithoutName = Sets.newHashSet();
    private final Set<String> myDependentsOnLibrariesWithoutBinaryPath = Sets.newHashSet();
    private final Set<InvalidModuleDependency> myInvalidModuleDependencies = Sets.newHashSet();

    public void addMissingModule(String dependencyName, String dependentName, String backupLibraryName) {
        Map<String, MissingModule> mapping = StringUtil.isNotEmpty((String)backupLibraryName) ? this.myMissingModulesWithBackupLibraries : this.myMissingModules;
        MissingModule missingModule = mapping.get(dependencyName);
        if (missingModule == null) {
            missingModule = new MissingModule(dependencyName, backupLibraryName);
            mapping.put(dependencyName, missingModule);
        }
        missingModule.addDependent(dependentName);
    }

    public void addMissingName(String dependentName) {
        this.myDependentsOnModulesWithoutName.add(dependentName);
    }

    public void addMissingBinaryPath(String dependentName) {
        this.myDependentsOnLibrariesWithoutBinaryPath.add(dependentName);
    }

    public void addInvalidModuleDependency(Module module, String targetModuleName, String detail) {
        this.myInvalidModuleDependencies.add(new InvalidModuleDependency(module, targetModuleName, detail));
    }

    public List<MissingModule> getMissingModules() {
        return DependencySetupErrors.getMissingModules(this.myMissingModules);
    }

    public List<MissingModule> getMissingModulesWithBackupLibraries() {
        return DependencySetupErrors.getMissingModules(this.myMissingModulesWithBackupLibraries);
    }

    private static List<MissingModule> getMissingModules(Map<String, MissingModule> missingModulesByName) {
        if (missingModulesByName.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList missingModules = Lists.newArrayList();
        ArrayList names = Lists.newArrayList(missingModulesByName.keySet());
        if (names.size() > 1) {
            Collections.sort(names);
        }
        for (String name : names) {
            MissingModule missingModule = missingModulesByName.get(name);
            missingModule.sortDependentNames();
            missingModules.add(missingModule);
        }
        return missingModules;
    }

    public List<String> getMissingNames() {
        return DependencySetupErrors.sortSet(this.myDependentsOnModulesWithoutName);
    }

    public List<String> getDependentsOnLibrariesWithoutBinaryPath() {
        return DependencySetupErrors.sortSet(this.myDependentsOnLibrariesWithoutBinaryPath);
    }

    public Set<InvalidModuleDependency> getInvalidModuleDependencies() {
        return this.myInvalidModuleDependencies;
    }

    private static List<String> sortSet(Set<String> set) {
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList sorted = Lists.newArrayList(set);
        if (sorted.size() > 1) {
            Collections.sort(sorted);
        }
        return sorted;
    }

    public static class InvalidModuleDependency {
        public final Module dependency;
        public final String dependent;
        public final String detail;

        InvalidModuleDependency(Module dependency, String dependent, String detail) {
            this.dependency = dependency;
            this.dependent = dependent;
            this.detail = detail;
        }
    }

    public static class MissingModule {
        public final String dependencyPath;
        public final List<String> dependentNames = Lists.newArrayList();
        public final String backupLibraryName;

        MissingModule(String dependencyPath, String backupLibraryName) {
            this.dependencyPath = dependencyPath;
            this.backupLibraryName = backupLibraryName;
        }

        void addDependent(String dependentName) {
            this.dependentNames.add(dependentName);
        }

        void sortDependentNames() {
            if (!this.dependentNames.isEmpty()) {
                Collections.sort(this.dependentNames);
            }
        }
    }
}

