/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<JavaProject> {
    private static final DependencyScope DEFAULT_DEPENDENCY_SCOPE = DependencyScope.COMPILE;

    @Override
    protected void setUpDependencies(ModifiableRootModel moduleModel, JavaProject javaProject) {
        ArrayList unresolved = Lists.newArrayList();
        for (JavaModuleDependency javaModuleDependency : javaProject.getJavaModuleDependencies()) {
            this.updateDependency(moduleModel, javaModuleDependency);
        }
        for (JarLibraryDependency jarLibraryDependency : javaProject.getJarLibraryDependencies()) {
            if (jarLibraryDependency.isResolved()) {
                this.updateDependency(moduleModel, jarLibraryDependency);
                continue;
            }
            unresolved.add(jarLibraryDependency.getName());
        }
        Module module = moduleModel.getModule();
        ProjectSyncMessages projectSyncMessages = ProjectSyncMessages.getInstance(moduleModel.getProject());
        projectSyncMessages.reportUnresolvedDependencies(unresolved, module);
        JavaGradleFacet facet = DependenciesModuleCustomizer.setAndGetJavaGradleFacet(module);
        File buildFolderPath = javaProject.getBuildFolderPath();
        if (!Projects.isGradleProjectModule(module)) {
            JavaModel javaModel = new JavaModel(unresolved, buildFolderPath);
            facet.setJavaModel(javaModel);
        }
        JavaGradleFacetConfiguration facetProperties = (JavaGradleFacetConfiguration)facet.getConfiguration();
        facetProperties.BUILD_FOLDER_PATH = buildFolderPath != null ? FileUtil.toSystemIndependentName((String)buildFolderPath.getPath()) : "";
        facetProperties.BUILDABLE = javaProject.isBuildable();
    }

    private void updateDependency(ModifiableRootModel moduleModel, JavaModuleDependency dependency) {
        DependencySetupErrors setupErrors = this.getSetupErrors(moduleModel.getProject());
        String moduleName = dependency.getModuleName();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)moduleModel.getProject());
        Module found = null;
        for (Module module : moduleManager.getModules()) {
            if (!moduleName.equals(module.getName())) continue;
            found = module;
        }
        if (found != null) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(found);
            if (androidFacet == null) {
                ModuleOrderEntry orderEntry = moduleModel.addModuleOrderEntry(found);
                orderEntry.setExported(true);
            } else {
                setupErrors.addInvalidModuleDependency(moduleModel.getModule(), found.getName(), "Java modules cannot depend on Android modules");
            }
            return;
        }
        setupErrors.addMissingModule(moduleName, moduleModel.getModule().getName(), null);
    }

    private void updateDependency(ModifiableRootModel moduleModel, JarLibraryDependency dependency) {
        DependencyScope scope = DependenciesModuleCustomizer.parseScope(dependency.getScope());
        File binaryPath = dependency.getBinaryPath();
        if (binaryPath == null) {
            DependencySetupErrors setupErrors = this.getSetupErrors(moduleModel.getProject());
            setupErrors.addMissingBinaryPath(moduleModel.getModule().getName());
            return;
        }
        String path = binaryPath.getPath();
        String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)path);
        DependenciesModuleCustomizer.setUpLibraryDependency(moduleModel, name, scope, Collections.singletonList(path), DependenciesModuleCustomizer.asPaths(dependency.getSourcePath()), DependenciesModuleCustomizer.asPaths(dependency.getJavadocPath()));
    }

    private static List<String> asPaths(File file) {
        return file == null ? Collections.emptyList() : Collections.singletonList(file.getPath());
    }

    private static DependencyScope parseScope(String scope) {
        if (scope == null) {
            return DEFAULT_DEPENDENCY_SCOPE;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scope.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return DEFAULT_DEPENDENCY_SCOPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaGradleFacet setAndGetJavaGradleFacet(Module module) {
        JavaGradleFacet facet = JavaGradleFacet.getInstance(module);
        if (facet != null) {
            return facet;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        try {
            facet = (JavaGradleFacet)facetManager.createFacet((FacetType)JavaGradleFacet.getFacetType(), "Java-Gradle", null);
            model.addFacet((Facet)facet);
        }
        finally {
            model.commit();
        }
        return facet;
    }
}

