/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class JavaLanguageLevelModuleCustomizer
implements ModuleCustomizer<JavaProject> {
    @Override
    public void customizeModule(Project project, ModifiableRootModel moduleModel, JavaProject javaProject) {
        if (javaProject == null) {
            return;
        }
        LanguageLevel languageLevel = javaProject.getJavaLanguageLevel();
        if (JavaLanguageLevelModuleCustomizer.isNotSupported(languageLevel)) {
            List dependents = ModuleUtilCore.getAllDependentModules((Module)moduleModel.getModule());
            languageLevel = JavaLanguageLevelModuleCustomizer.getMinimumLanguageLevelForAndroidModules(dependents.toArray(new Module[dependents.size()]));
        }
        if (JavaLanguageLevelModuleCustomizer.isNotSupported(languageLevel)) {
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            languageLevel = JavaLanguageLevelModuleCustomizer.getMinimumLanguageLevelForAndroidModules(modules);
        }
        if (JavaLanguageLevelModuleCustomizer.isNotSupported(languageLevel)) {
            languageLevel = LanguageLevel.JDK_1_6;
        }
        ((LanguageLevelModuleExtensionImpl)moduleModel.getModuleExtension(LanguageLevelModuleExtensionImpl.class)).setLanguageLevel(languageLevel);
    }

    private static boolean isNotSupported(LanguageLevel languageLevel) {
        return languageLevel == null || languageLevel.compareTo((Enum)LanguageLevel.JDK_1_8) >= 0;
    }

    private static LanguageLevel getMinimumLanguageLevelForAndroidModules(Module[] modules) {
        if (modules.length == 0) {
            return null;
        }
        LanguageLevel result = null;
        ArrayList languageLevels = Lists.newArrayList();
        for (Module dependency : modules) {
            LanguageLevel dependencyLanguageLevel = JavaLanguageLevelModuleCustomizer.getLanguageLevelForAndroidModule(dependency);
            if (dependencyLanguageLevel == null) continue;
            languageLevels.add(dependencyLanguageLevel);
        }
        for (LanguageLevel dependencyLanguageLevel : languageLevels) {
            if (result != null && result.compareTo((Enum)dependencyLanguageLevel) <= 0) continue;
            result = dependencyLanguageLevel;
        }
        return result;
    }

    private static LanguageLevel getLanguageLevelForAndroidModule(Module module) {
        AndroidGradleModel androidModel;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidModel = AndroidGradleModel.get(facet)) != null) {
            return androidModel.getJavaLanguageLevel();
        }
        return null;
    }
}

