/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.tools.idea.dependencies.DependencyManager;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class GradleDependencyManager
extends DependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    public static GradleDependencyManager getInstance(Project project) {
        return (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
    }

    @Override
    public List<String> findMissingDependencies(Module module, Iterable<String> androidDependencies) {
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(module);
        assert (gradleBuildFile != null);
        return GradleDependencyManager.findMissingLibrariesFromGradleBuildFile(gradleBuildFile, androidDependencies);
    }

    @Override
    public boolean ensureLibraryIsIncluded(Module module, Iterable<String> androidDependencies, Runnable callback) {
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(module);
        assert (gradleBuildFile != null);
        List<String> missing = GradleDependencyManager.findMissingLibrariesFromGradleBuildFile(gradleBuildFile, androidDependencies);
        if (missing.isEmpty()) {
            return true;
        }
        if (GradleDependencyManager.userWantToAddDependencies(module, missing)) {
            GradleDependencyManager.addDependenciesInTransaction(gradleBuildFile, module, missing, callback);
        }
        return false;
    }

    private static List<String> findMissingLibrariesFromGradleBuildFile(GradleBuildFile gradleBuildFile, Iterable<String> pathIds) {
        ArrayList missingLibraries = Lists.newArrayList();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        for (String pathId : pathIds) {
            String libraryCoordinate = manager.getLibraryCoordinate(pathId);
            boolean dependencyFound = false;
            for (BuildFileStatement entry : gradleBuildFile.getDependencies()) {
                if (!(entry instanceof Dependency)) continue;
                Dependency dependency = (Dependency)entry;
                if (dependency.scope != Dependency.Scope.COMPILE || dependency.type != Dependency.Type.EXTERNAL || !dependency.getValueAsString().equals(libraryCoordinate)) continue;
                dependencyFound = true;
                break;
            }
            if (dependencyFound) continue;
            missingLibraries.add(pathId);
        }
        return missingLibraries;
    }

    private static boolean userWantToAddDependencies(Module module, List<String> missing) {
        String libraryNames = StringUtil.join(missing, (String)", ");
        String message = String.format("This operation requires the %1$s: %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    private static void addDependenciesInTransaction(final GradleBuildFile gradleBuildFile, final Module module, List<String> missing, final Runnable callback) {
        assert (!missing.isEmpty());
        final ArrayList missingLibraryCoordinates = Lists.newArrayList();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        for (String pathId : missing) {
            missingLibraryCoordinates.add(manager.getLibraryCoordinate(pathId));
        }
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                GradleDependencyManager.addDependencies(gradleBuildFile, module, missingLibraryCoordinates);
                GradleProjectImporter.getInstance().requestProjectSync(project, false, GradleDependencyManager.createSyncListener(callback));
            }
        }.execute();
    }

    private static void addDependencies(final GradleBuildFile gradleBuildFile, Module module, final List<String> libraryCoordinates) {
        ModuleRootModificationUtil.updateModel((Module)module, (Consumer)new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                List<BuildFileStatement> dependencies = gradleBuildFile.getDependencies();
                for (String libraryCoordinate : libraryCoordinates) {
                    dependencies.add(new Dependency(Dependency.Scope.COMPILE, Dependency.Type.EXTERNAL, libraryCoordinate));
                }
                gradleBuildFile.setValue(BuildFileKey.DEPENDENCIES, dependencies);
            }
        });
    }

    private static GradleSyncListener createSyncListener(final Runnable callback) {
        if (callback == null) {
            return null;
        }
        return new GradleSyncListener(){

            @Override
            public void syncStarted(Project project) {
            }

            @Override
            public void syncSucceeded(Project project) {
                callback.run();
            }

            @Override
            public void syncFailed(Project project, String errorMessage) {
            }

            @Override
            public void syncSkipped(Project project) {
                callback.run();
            }
        };
    }
}

