/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependencyElement;
import com.android.tools.idea.gradle.dsl.parser.ExternalDependencyElement;
import com.android.tools.idea.gradle.dsl.parser.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.ProjectDependencyElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;

public class DependenciesElement
implements GradleDslElement {
    private final GrClosableBlock myPsiElement;
    private final List<ExternalDependencyElement> myExternalDependencies = Lists.newArrayList();
    private final List<ProjectDependencyElement> myProjectDependencies = Lists.newArrayList();

    DependenciesElement(GrClosableBlock psiElement) {
        this.myPsiElement = psiElement;
    }

    void addAll(List<DependencyElement> dependencies) {
        for (DependencyElement dependency : dependencies) {
            this.add(dependency);
        }
    }

    private void add(DependencyElement dependency) {
        if (dependency instanceof ExternalDependencyElement) {
            this.myExternalDependencies.add((ExternalDependencyElement)dependency);
        } else if (dependency instanceof ProjectDependencyElement) {
            this.myProjectDependencies.add((ProjectDependencyElement)dependency);
        }
    }

    public ImmutableList<ExternalDependencyElement> getExternalDependencies() {
        return ImmutableList.copyOf(this.myExternalDependencies);
    }

    public ImmutableList<ProjectDependencyElement> getProjectDependencies() {
        return ImmutableList.copyOf(this.myProjectDependencies);
    }

    public void addExternalDependency(String configurationName, String compactNotation) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Project project = this.myPsiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrStatement statement = factory.createStatementFromText((CharSequence)(configurationName + " '" + compactNotation + "'"));
        this.myPsiElement.addStatementBefore(statement, null);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)statement);
    }
}

