/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependenciesElement;
import com.android.tools.idea.gradle.dsl.parser.DependencyElement;
import com.android.tools.idea.gradle.dsl.parser.ExternalDependencyElement;
import com.android.tools.idea.gradle.dsl.parser.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslElementParser;
import com.android.tools.idea.gradle.dsl.parser.ProjectDependencyElement;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

class DependenciesElementParser
implements GradleDslElementParser {
    DependenciesElementParser() {
    }

    @Override
    public boolean parse(GroovyPsiElement e, GradleBuildModel buildFile) {
        GrClosableBlock closableBlock;
        GrArgumentList argumentList;
        GrMethodCallExpression expression;
        GrReferenceExpression childExpression;
        if (e instanceof GrMethodCallExpression && (childExpression = (GrReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)(expression = (GrMethodCallExpression)e), GrReferenceExpression.class)) != null && "dependencies".equals(childExpression.getText()) && (argumentList = (GrArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)childExpression, GrArgumentList.class)) != null && argumentList.getAllArguments().length == 0 && (closableBlock = (GrClosableBlock)PsiTreeUtil.getNextSiblingOfType((PsiElement)argumentList, GrClosableBlock.class)) != null) {
            DependenciesElementParser.parse(closableBlock, buildFile);
            return true;
        }
        return false;
    }

    private static void parse(GrClosableBlock closure, GradleBuildModel buildFile) {
        GrApplicationStatement[] statements;
        DependenciesElement dependencies = new DependenciesElement(closure);
        GrMethodCallExpression[] expressions = (GrMethodCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)closure, GrMethodCallExpression.class);
        if (expressions != null) {
            for (GrMethodCallExpression expression : expressions) {
                List<DependencyElement> dependencyList = DependenciesElementParser.parseDependencies(expression);
                dependencies.addAll(dependencyList);
            }
        }
        if ((statements = (GrApplicationStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)closure, GrApplicationStatement.class)) != null) {
            for (GrApplicationStatement statement : statements) {
                List<DependencyElement> dependencyList = DependenciesElementParser.parseDependencies(statement);
                dependencies.addAll(dependencyList);
            }
        }
        buildFile.add(dependencies);
    }

    private static List<DependencyElement> parseDependencies(GrApplicationStatement statement) {
        GroovyPsiElement[] arguments;
        int argumentCount;
        GrCommandArgumentList argumentList;
        String configurationName;
        ArrayList dependencies = Lists.newArrayList();
        GrReferenceExpression configurationNameExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, GrReferenceExpression.class);
        if (configurationNameExpression != null && StringUtil.isNotEmpty((String)(configurationName = configurationNameExpression.getText())) && (argumentList = (GrCommandArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)configurationNameExpression, GrCommandArgumentList.class)) != null && (argumentCount = (arguments = argumentList.getAllArguments()).length) > 0) {
            DependencyElement dependencyElement;
            GroovyPsiElement argument = arguments[0];
            if (argument instanceof GrLiteral) {
                dependencies.addAll(DependenciesElementParser.parseExternalDependenciesWithCompactNotation(configurationName, arguments));
            } else if (argument instanceof GrNamedArgument) {
                dependencies.addAll(DependenciesElementParser.parseExternalDependenciesWithMapNotation(configurationName, arguments));
            } else if (argument instanceof GrMethodCallExpression && (dependencyElement = DependenciesElementParser.parseDependencies(configurationName, (GrMethodCallExpression)argument)) != null) {
                dependencies.add(dependencyElement);
            }
        }
        return dependencies;
    }

    private static List<DependencyElement> parseExternalDependenciesWithCompactNotation(String configurationName, GroovyPsiElement[] arguments) {
        ArrayList dependencies = Lists.newArrayList();
        for (GroovyPsiElement argument : arguments) {
            GrLiteral literal;
            ExternalDependencyElement dependency;
            if (!(argument instanceof GrLiteral) || (dependency = ExternalDependencyElement.withCompactNotation(configurationName, literal = (GrLiteral)argument)) == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private static List<DependencyElement> parseExternalDependenciesWithMapNotation(String configurationName, GroovyPsiElement[] arguments) {
        ArrayList dependencies = Lists.newArrayList();
        ArrayList namedArguments = Lists.newArrayList();
        for (GroovyPsiElement argument : arguments) {
            if (!(argument instanceof GrNamedArgument)) continue;
            namedArguments.add((GrNamedArgument)argument);
        }
        ExternalDependencyElement dependency = ExternalDependencyElement.withMapNotation(configurationName, namedArguments);
        if (dependency != null) {
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private static DependencyElement parseDependencies(String configurationName, GrMethodCallExpression expression) {
        String referenceName;
        GrReferenceExpression referenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, GrReferenceExpression.class);
        if (referenceExpression != null && StringUtil.isNotEmpty((String)(referenceName = referenceExpression.getText())) && "project".equals(referenceName)) {
            return DependenciesElementParser.parseProjectDependency(configurationName, expression.getArgumentList());
        }
        return null;
    }

    private static DependencyElement parseProjectDependency(String configurationName, GrArgumentList argumentList) {
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        if (arguments.length == 0) {
            return null;
        }
        if (arguments.length == 1 && arguments[0] instanceof GrLiteral) {
            return ProjectDependencyElement.withCompactNotation(configurationName, (GrLiteralContainer)((GrLiteral)arguments[0]));
        }
        return ProjectDependencyElement.withMapNotation(configurationName, argumentList);
    }

    private static List<DependencyElement> parseDependencies(GrMethodCallExpression expression) {
        GrArgumentList argumentList;
        String configurationName;
        ArrayList dependencies = Lists.newArrayList();
        GrReferenceExpression configurationNameExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, GrReferenceExpression.class);
        if (configurationNameExpression != null && StringUtil.isNotEmpty((String)(configurationName = configurationNameExpression.getText())) && (argumentList = (GrArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)configurationNameExpression, GrArgumentList.class)) != null) {
            for (GroovyPsiElement arg : argumentList.getAllArguments()) {
                ExternalDependencyElement dependency;
                Object[] namedArgs;
                GrListOrMap listOrMap;
                if (!(arg instanceof GrListOrMap) || !(listOrMap = (GrListOrMap)arg).isMap() || (namedArgs = listOrMap.getNamedArguments()).length <= 0 || (dependency = ExternalDependencyElement.withMapNotation(configurationName, Lists.newArrayList((Object[])namedArgs))) == null) continue;
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }
}

