/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependencyElement;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ExternalDependencyElement
implements DependencyElement {
    private final String myConfigurationName;
    private final Notation myNotation;

    static ExternalDependencyElement withCompactNotation(String configurationName, GrLiteral literal) {
        CompactNotation notation = CompactNotation.parse(literal);
        if (notation != null) {
            return new ExternalDependencyElement(configurationName, notation);
        }
        return null;
    }

    static ExternalDependencyElement withMapNotation(String configurationName, List<GrNamedArgument> namedArguments) {
        MapNotation notation = MapNotation.parse(namedArguments);
        if (notation != null) {
            return new ExternalDependencyElement(configurationName, notation);
        }
        return null;
    }

    private ExternalDependencyElement(String configurationName, Notation notation) {
        this.myConfigurationName = configurationName;
        this.myNotation = notation;
    }

    public String getConfigurationName() {
        return this.myConfigurationName;
    }

    public String getGroup() {
        return this.myNotation.getSpec().group;
    }

    public String getName() {
        return this.myNotation.getSpec().name;
    }

    public String getVersion() {
        return this.myNotation.getSpec().version;
    }

    public void setVersion(String version) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myNotation.setVersion(version);
    }

    public String getClassifier() {
        return this.myNotation.getSpec().classifier;
    }

    public String getExtension() {
        return this.myNotation.getSpec().extension;
    }

    public String toString() {
        return "ExternalDependencyElement{configurationName='" + this.myConfigurationName + '\'' + ", spec='" + this.myNotation.getSpec() + '\'' + '}';
    }

    static class DependencySpec {
        String name;
        String group;
        String version;
        String classifier;
        String extension;

        DependencySpec(String name, String group, String version, String classifier, String extension) {
            this.name = name;
            this.group = Strings.emptyToNull((String)group);
            this.version = Strings.emptyToNull((String)version);
            this.classifier = Strings.emptyToNull((String)classifier);
            this.extension = Strings.emptyToNull((String)extension);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencySpec that = (DependencySpec)o;
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.classifier, (Object)that.classifier) && Objects.equal((Object)this.extension, (Object)that.extension);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.group, this.version, this.classifier, this.extension});
        }

        public String toString() {
            ArrayList segments = Lists.newArrayList((Object[])new String[]{this.group, this.name, this.version, this.classifier});
            String s = Joiner.on((char)':').skipNulls().join((Iterable)segments);
            if (this.extension != null) {
                s = s + "@" + this.extension;
            }
            return s;
        }
    }

    static class MapNotation
    implements Notation {
        @NonNls
        private static final String VERSION_PROPERTY = "version";
        private final Map<String, GrLiteral> myArgumentsByName;
        private final DependencySpec mySpec;

        static MapNotation parse(List<GrNamedArgument> namedArguments) {
            HashMap argumentsByName = Maps.newHashMap();
            HashMap argumentValuesByName = Maps.newHashMap();
            for (GrNamedArgument argument : namedArguments) {
                GrLiteral literal = (GrLiteral)PsiTreeUtil.getChildOfType((PsiElement)argument, GrLiteral.class);
                if (literal == null) continue;
                String name = argument.getLabelName();
                argumentsByName.put(name, literal);
                argumentValuesByName.put(name, PsiElements.getUnquotedText(literal));
            }
            DependencySpec spec = MapNotation.parse(argumentValuesByName);
            if (spec != null) {
                return new MapNotation(argumentsByName, spec);
            }
            return null;
        }

        static DependencySpec parse(Map<String, String> namedArguments) {
            String name = namedArguments.get("name");
            if (StringUtil.isNotEmpty((String)name)) {
                return new DependencySpec(name, namedArguments.get("group"), namedArguments.get(VERSION_PROPERTY), namedArguments.get("classifier"), namedArguments.get("ext"));
            }
            return null;
        }

        private MapNotation(Map<String, GrLiteral> argumentsByName, DependencySpec spec) {
            this.myArgumentsByName = argumentsByName;
            this.mySpec = spec;
        }

        @Override
        public DependencySpec getSpec() {
            return this.mySpec;
        }

        @Override
        public void setVersion(String version) {
            GrLiteral literal = this.myArgumentsByName.get(VERSION_PROPERTY);
            if (literal != null) {
                Project project = literal.getProject();
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
                this.mySpec.version = version;
                GrLiteral newCoordinatePsiLiteral = factory.createLiteralFromValue((Object)version);
                literal.replace((PsiElement)newCoordinatePsiLiteral);
            }
        }
    }

    static class CompactNotation
    implements Notation {
        private final GrLiteral myLiteral;
        private final DependencySpec mySpec;

        static CompactNotation parse(GrLiteral literal) {
            DependencySpec spec;
            String text = PsiElements.getUnquotedText(literal);
            if (text != null && (spec = CompactNotation.parse(text)) != null) {
                return new CompactNotation(literal, spec);
            }
            return null;
        }

        static DependencySpec parse(String text) {
            List segments = Splitter.on((char)':').trimResults().omitEmptyStrings().splitToList((CharSequence)text);
            int segmentCount = segments.size();
            if (segmentCount > 0) {
                segments = Lists.newArrayList((Iterable)segments);
                String lastSegment = (String)segments.remove(segmentCount - 1);
                String extension = null;
                int indexOfAt = lastSegment.indexOf(64);
                if (indexOfAt != -1) {
                    extension = lastSegment.substring(indexOfAt + 1, lastSegment.length());
                    lastSegment = lastSegment.substring(0, indexOfAt);
                }
                segments.add(lastSegment);
                segmentCount = segments.size();
                String group = null;
                String name = null;
                String version = null;
                String classifier = null;
                if (segmentCount == 1) {
                    name = (String)segments.get(0);
                } else if (segmentCount == 2) {
                    if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                        name = (String)segments.get(0);
                        version = lastSegment;
                    } else {
                        group = (String)segments.get(0);
                        name = (String)segments.get(1);
                    }
                } else if (segmentCount == 3 || segmentCount == 4) {
                    group = (String)segments.get(0);
                    name = (String)segments.get(1);
                    version = (String)segments.get(2);
                    if (segmentCount == 4) {
                        classifier = (String)segments.get(3);
                    }
                }
                if (StringUtil.isNotEmpty((String)name)) {
                    return new DependencySpec(name, group, version, classifier, extension);
                }
            }
            return null;
        }

        private CompactNotation(GrLiteral literal, DependencySpec spec) {
            this.myLiteral = literal;
            this.mySpec = spec;
        }

        @Override
        public DependencySpec getSpec() {
            return this.mySpec;
        }

        @Override
        public void setVersion(String version) {
            Project project = this.myLiteral.getProject();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
            this.mySpec.version = version;
            GrLiteral newCoordinatePsiLiteral = factory.createLiteralFromValue((Object)this.mySpec.toString());
            this.myLiteral.replace((PsiElement)newCoordinatePsiLiteral);
        }
    }

    private static interface Notation {
        public DependencySpec getSpec();

        public void setVersion(String var1);
    }
}

