/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependenciesElement;
import com.android.tools.idea.gradle.dsl.parser.DependenciesElementParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslElementParser;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.SystemProperties;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel {
    private final VirtualFile myFile;
    private final Project myProject;
    private final List<DependenciesElement> myDependenciesBlocks = Lists.newArrayList();
    private final GradleDslElementParser[] myParsers = new GradleDslElementParser[]{new DependenciesElementParser()};
    private PsiFile myPsiFile;

    public static GradleBuildModel get(Module module) {
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModel.parseBuildFile(file, module.getProject()) : null;
    }

    public static GradleBuildModel parseBuildFile(VirtualFile file, Project project) {
        GradleBuildModel buildFile = new GradleBuildModel(file, project);
        buildFile.reparse();
        return buildFile;
    }

    private GradleBuildModel(VirtualFile file, Project project) {
        this.myFile = file;
        this.myProject = project;
    }

    public void reparse() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.reset();
        this.myPsiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (this.myPsiFile != null) {
            this.myPsiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    for (GradleDslElementParser parser : GradleBuildModel.this.myParsers) {
                        if (parser.parse((GroovyPsiElement)e, GradleBuildModel.this)) break;
                    }
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    for (GradleDslElementParser parser : GradleBuildModel.this.myParsers) {
                        if (parser.parse((GroovyPsiElement)e, GradleBuildModel.this)) break;
                    }
                }
            }));
        }
    }

    private void reset() {
        this.myDependenciesBlocks.clear();
    }

    void add(DependenciesElement dependencies) {
        this.myDependenciesBlocks.add(dependencies);
    }

    public ImmutableList<DependenciesElement> getDependenciesBlocks() {
        return ImmutableList.copyOf(this.myDependenciesBlocks);
    }

    public void addExternalDependency(String configurationName, String compactNotation) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (this.myPsiFile != null);
        if (this.myDependenciesBlocks.isEmpty()) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)this.myProject);
            String lineSeparator = SystemProperties.getLineSeparator();
            String text = "dependencies {" + lineSeparator + configurationName + " '" + compactNotation + "'" + lineSeparator + "}";
            GrExpression expression = factory.createExpressionFromText((CharSequence)text);
            this.myPsiFile.add((PsiElement)expression);
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)expression);
        } else {
            DependenciesElement dependenciesBlock = this.myDependenciesBlocks.get(0);
            dependenciesBlock.addExternalDependency(configurationName, compactNotation);
        }
    }

    public boolean hasPsiFile() {
        return this.myPsiFile != null;
    }
}

