/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependencyElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;

public class ProjectDependencyElement
implements DependencyElement {
    String myConfigurationName;
    GrLiteralContainer myGradlePathElement;
    GrLiteralContainer myTargetConfigurationElement;

    public static ProjectDependencyElement withCompactNotation(String configurationName, GrLiteralContainer projectNamePsiElement) {
        if (projectNamePsiElement.getValue() == null) {
            return null;
        }
        return new ProjectDependencyElement(configurationName, projectNamePsiElement, null);
    }

    public static ProjectDependencyElement withMapNotation(String configurationName, GrArgumentList argumentList) {
        GrLiteral projectNamePsiElement = ProjectDependencyElement.findNamedArgumentLiteralValue(argumentList, "path");
        if (projectNamePsiElement == null || projectNamePsiElement.getValue() == null) {
            return null;
        }
        return new ProjectDependencyElement(configurationName, (GrLiteralContainer)projectNamePsiElement, (GrLiteralContainer)ProjectDependencyElement.findNamedArgumentLiteralValue(argumentList, "configuration"));
    }

    private static GrLiteral findNamedArgumentLiteralValue(GrArgumentList argumentList, String label) {
        GrNamedArgument namedArgument = argumentList.findNamedArgument(label);
        if (namedArgument == null) {
            return null;
        }
        if (namedArgument.getExpression() instanceof GrLiteral) {
            return (GrLiteral)namedArgument.getExpression();
        }
        return null;
    }

    private ProjectDependencyElement(String configurationName, GrLiteralContainer projectNamePsiElement, GrLiteralContainer targetConfigurationElement) {
        this.myConfigurationName = configurationName;
        this.myGradlePathElement = projectNamePsiElement;
        this.myTargetConfigurationElement = targetConfigurationElement;
    }

    public String getConfigurationName() {
        return this.myConfigurationName;
    }

    public String getPath() {
        Object literalValue = this.myGradlePathElement.getValue();
        assert (literalValue != null);
        return literalValue.toString();
    }

    public String getName() {
        List<String> pathSegments = GradleUtil.getPathSegments(this.getPath());
        int segmentCount = pathSegments.size();
        return segmentCount > 0 ? pathSegments.get(segmentCount - 1) : "";
    }

    public String getTargetConfiguration() {
        if (this.myTargetConfigurationElement == null) {
            return null;
        }
        Object value = this.myTargetConfigurationElement.getValue();
        return value != null ? value.toString() : null;
    }

    public void setName(String newName) {
        String newPath;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List segments = Splitter.on((String)":").splitToList((CharSequence)this.getPath());
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + newName.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, newName);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        String currentText = this.myGradlePathElement.getText();
        char quote = '\'';
        if (StringUtil.isQuotedString((String)currentText)) {
            quote = currentText.charAt(0);
        }
        newPath = quote + newPath + quote;
        this.myGradlePathElement = this.myGradlePathElement.updateText(newPath);
    }
}

