/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor;

import com.android.tools.idea.gradle.editor.GradleEditorNotificationListener;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntityGroup;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParserFacade;
import com.android.tools.idea.gradle.editor.ui.GradleEditorComponent;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.messages.MessageBusConnection;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.util.AndroidBundle;

public class GradleFileEditor
extends UserDataHolderBase
implements FileEditor {
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private final GradleEditorComponent myComponent;
    private Document myDocument;
    private DocumentListener myDocumentListener;
    private MessageBusConnection myConnection;
    private List<GradleEditorEntityGroup> myGroups;
    private volatile boolean myEditorTriggeredModificationInProgress;

    public GradleFileEditor(VirtualFile virtualFile, Project project) {
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myGroups = new GradleEditorModelParserFacade().parse(virtualFile, project);
        this.myComponent = new GradleEditorComponent(project, this.myGroups);
        this.myDocument = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (this.myDocument == null) {
            this.myDocumentListener = null;
            this.myConnection = null;
        } else {
            this.myDocumentListener = new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    Document document = e.getDocument();
                    if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
                        return;
                    }
                    if (!GradleFileEditor.this.myEditorTriggeredModificationInProgress) {
                        GradleFileEditor.this.refresh();
                    }
                }
            };
            this.myDocument.addDocumentListener(this.myDocumentListener);
            this.myConnection = project.getMessageBus().connect();
            this.myConnection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

                public void updateFinished(Document doc) {
                    if (!GradleFileEditor.this.myEditorTriggeredModificationInProgress) {
                        GradleFileEditor.this.refresh();
                    }
                }
            });
            this.myConnection.subscribe(GradleEditorNotificationListener.TOPIC, (Object)new GradleEditorNotificationListener(){

                @Override
                public void beforeChange() {
                    GradleFileEditor.this.myEditorTriggeredModificationInProgress = true;
                }

                @Override
                public void afterChange() {
                    GradleFileEditor.this.myEditorTriggeredModificationInProgress = false;
                }
            });
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getName() {
        return AndroidBundle.message("android.gradle.editor.tab.name", new Object[0]);
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.refresh();
    }

    public void deselectNotify() {
        this.myComponent.flushChanges();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.myDocument != null && this.myDocumentListener != null) {
            this.myDocument.removeDocumentListener(this.myDocumentListener);
            this.myDocument = null;
            this.myDocumentListener = null;
        }
        if (this.myConnection != null) {
            this.myConnection.disconnect();
        }
        this.disposeGroups();
    }

    public void refresh() {
        if (this.myDocument != null) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            psiDocumentManager.commitDocument(this.myDocument);
        }
        this.disposeGroups();
        this.myGroups = new GradleEditorModelParserFacade().parse(this.myVirtualFile, this.myProject);
        this.myComponent.setData(this.myGroups);
    }

    private void disposeGroups() {
        List<GradleEditorEntityGroup> groups = this.myGroups;
        if (groups != null) {
            for (GradleEditorEntityGroup group : groups) {
                Disposer.dispose((Disposable)group);
            }
            this.myGroups = null;
        }
    }
}

