/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.AbstractGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDeclarationValueLocationAware;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDefinitionValueLocationAware;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class AbstractSimpleGradleEditorEntity
extends AbstractGradleEditorEntity
implements GradleEntityDeclarationValueLocationAware,
GradleEntityDefinitionValueLocationAware {
    private final String myName;
    private final List<GradleEditorSourceBinding> myDefinitionValueSourceBindings;
    private final GradleEditorEntityValueManager myValueManager;
    private final GradleEditorSourceBinding myDeclarationValueLocation;
    private String myCurrentValue;

    public AbstractSimpleGradleEditorEntity(String name, String currentValue, Collection<GradleEditorSourceBinding> definitionValueSourceBindings, GradleEditorSourceBinding entityLocation, Set<GradleEditorEntityMetaData> metaData, GradleEditorSourceBinding declarationValueLocation, GradleEditorEntityValueManager valueManager, String helpUrl) {
        super(entityLocation, metaData, helpUrl);
        this.myName = name;
        this.myCurrentValue = currentValue;
        this.myDefinitionValueSourceBindings = ImmutableList.copyOf(definitionValueSourceBindings);
        this.myDeclarationValueLocation = declarationValueLocation;
        this.myValueManager = valueManager;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String getCurrentValue() {
        return this.myCurrentValue;
    }

    @Override
    public GradleEditorSourceBinding getDeclarationValueLocation() {
        return this.myDeclarationValueLocation;
    }

    @Override
    public GradleEditorSourceBinding getDefinitionValueLocation() {
        return this.myDefinitionValueSourceBindings.size() == 1 ? this.myDefinitionValueSourceBindings.get(0) : null;
    }

    public String changeValue(String newValue) {
        if (newValue.equals(this.getCurrentValue())) {
            return null;
        }
        List<GradleEditorSourceBinding> sourceBindings = this.getDefinitionValueSourceBindings();
        if (sourceBindings.size() != 1) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: expected the entity to hold only one source binding but it has %d (%s)", newValue, this, sourceBindings.size(), sourceBindings);
        }
        GradleEditorSourceBinding binding = sourceBindings.get(0);
        RangeMarker rangeMarker = binding.getRangeMarker();
        if (!rangeMarker.isValid()) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: source file binding is incorrect", newValue, this);
        }
        this.myCurrentValue = newValue;
        rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)newValue);
        return null;
    }

    public List<GradleEditorSourceBinding> getDefinitionValueSourceBindings() {
        return this.myDefinitionValueSourceBindings;
    }

    public GradleEditorEntityValueManager getValueManager() {
        return this.myValueManager;
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myDeclarationValueLocation);
        for (GradleEditorSourceBinding sourceBinding : this.myDefinitionValueSourceBindings) {
            Disposer.dispose((Disposable)sourceBinding);
        }
    }

    public String toString() {
        String value;
        List<GradleEditorSourceBinding> bindings = this.getDefinitionValueSourceBindings();
        if (bindings.isEmpty()) {
            value = "<undefined>";
        } else if (bindings.size() > 1) {
            value = "<ref>";
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(bindings.get(0).getFile());
            RangeMarker rangeMarker = bindings.get(0).getRangeMarker();
            value = document == null ? "<unexpected!>" : '[' + ((Object)document.getCharsSequence().subSequence(rangeMarker.getStartOffset(), rangeMarker.getEndOffset())).toString() + ']';
        }
        return this.getName() + " " + value;
    }
}

